/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.util.GreenMailUtil;
import java.util.List;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;

public class TestNotificationEmails
extends EmailFuncTestCase {
    private static final String ADMIN_ONLY_KEY = "HSP-1";
    private static final String ADMIN_ONLY_SUMMARY = "Admin Not Watched";
    private static final String BOTH_KEY = "HSP-2";
    private static final String BOTH_SUMMARY = "Admin Watched by Fred";
    private static final String EMAIL_PREFIX = "JIRATEST";
    private static final String EDIT_ISSUE_COMMENT = "Edit issue comment.";
    private static final String COMMENT_ON_ISSUE_COMMENT = "Comment on the issue comment.";
    private static final String ASSIGN_ISSUE_COMMENT = "I am assigning this issue to myself.";
    private static final String RESOLVE_ISSUE_COMMENT = "I resolved the issue.";
    private static final String REOPEN_ISSUE_COMMENT = "I reopened the issue.";
    private static final String ADMIN_FULL_NAME = "Administrator";
    private static final String ADMIN_EMAIL = "admin@example.com";
    private static final String FRED_EMAIL = "fred@example.com";
    private static final String GROUP_PRIVATE = "GROUP PRIVATE: ";
    private static final String ROLE_PRIVATE = "ROLE PRIVATE: ";
    private static final String GROUPS_ADMINS = "jira-administrators";
    private static final String ROLE_ADMINS = "Administrators";
    private static final String UNASSIGNED = "Unassigned";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestNotificationEmails.xml");
        this.configureAndStartSmtpServer();
    }

    public void testEmailHasCommentsWhenEditIssue() throws Exception {
        MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        MailBox fredFolder = this.getMailBox(FRED_EMAIL);
        this.navigation.issue().gotoIssue(ADMIN_ONLY_KEY);
        this.updateIssue(EDIT_ISSUE_COMMENT, null, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Updated", ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, false);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(EDIT_ISSUE_COMMENT, null, null);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Updated", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Updated", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, EDIT_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(EDIT_ISSUE_COMMENT);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(comment, GROUPS_ADMINS, "Blocker");
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Updated", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(EDIT_ISSUE_COMMENT);
        this.navigation.issue().gotoIssue(BOTH_KEY);
        this.updateIssue(comment, ROLE_ADMINS, "Minor");
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Updated", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
    }

    public void testEmailHasCommentWhenAddingComment() throws Exception {
        MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        MailBox fredFolder = this.getMailBox(FRED_EMAIL);
        this.addIssueComment(ADMIN_ONLY_KEY, COMMENT_ON_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Commented", ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        this.addIssueComment(BOTH_KEY, COMMENT_ON_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Commented", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Commented", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, COMMENT_ON_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(COMMENT_ON_ISSUE_COMMENT);
        this.addIssueComment(BOTH_KEY, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Commented", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(COMMENT_ON_ISSUE_COMMENT);
        this.addIssueComment(BOTH_KEY, comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Commented", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
    }

    public void testEmailHasCommentWhenAssigningIssue() throws Exception {
        MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        MailBox fredFolder = this.getMailBox(FRED_EMAIL);
        this.assignIssue(ADMIN_ONLY_KEY, ADMIN_FULL_NAME, ASSIGN_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Assigned", ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        this.assignIssue(BOTH_KEY, ADMIN_FULL_NAME, ASSIGN_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Assigned", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Assigned", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, ASSIGN_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(ASSIGN_ISSUE_COMMENT);
        this.assignIssue(BOTH_KEY, UNASSIGNED, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Assigned", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        comment = this.createRoleComment(ASSIGN_ISSUE_COMMENT);
        this.assignIssue(BOTH_KEY, ADMIN_FULL_NAME, comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Assigned", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
    }

    public void testEmailHasCommentWhenTransitingIssue() throws Exception {
        MailBox adminFolder = this.getMailBox(ADMIN_EMAIL);
        MailBox fredFolder = this.getMailBox(FRED_EMAIL);
        this.resolveIssue(ADMIN_ONLY_KEY, RESOLVE_ISSUE_COMMENT, null);
        MimeMessage message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Resolved", ADMIN_ONLY_KEY, ADMIN_ONLY_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, false);
        TestNotificationEmails.assertNull((Object)fredFolder.nextMessage());
        this.resolveIssue(BOTH_KEY, RESOLVE_ISSUE_COMMENT, null);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Resolved", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Resolved", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, RESOLVE_ISSUE_COMMENT, true);
        String comment = this.createGroupComment(REOPEN_ISSUE_COMMENT);
        this.reopenIssue(BOTH_KEY, comment, GROUPS_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Reopened", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Reopened", BOTH_KEY, BOTH_SUMMARY);
        this.assertNotMessageAndType(message, comment, true);
        comment = this.createRoleComment(RESOLVE_ISSUE_COMMENT);
        this.resolveIssue(BOTH_KEY, comment, ROLE_ADMINS);
        message = adminFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Resolved", BOTH_KEY, BOTH_SUMMARY);
        this.assertMessageAndType(message, comment, false);
        message = fredFolder.awaitMessage();
        this.assertTextSequence(message.getSubject(), EMAIL_PREFIX, "Resolved", BOTH_KEY, BOTH_SUMMARY);
        this.assertNotMessageAndType(message, comment, true);
    }

    private void updateIssue(String comment, String security, String priority) throws InterruptedException {
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("comment", comment);
        if (StringUtils.isNotBlank((String)priority)) {
            this.tester.selectOption("priority", priority);
        }
        if (StringUtils.isNotBlank((String)security)) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.clickButton("issue-edit-submit");
        this.flushMailQueueAndWait(1);
    }

    private void addIssueComment(String key, String comment, String security) throws InterruptedException {
        this.navigation.issue().addComment(key, comment, security);
        this.flushMailQueueAndWait(1);
    }

    private void assignIssue(String key, String username, String comment, String security) throws InterruptedException {
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLink("assign-issue");
        this.tester.selectOption("assignee", username);
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        if (security != null) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.clickButton("assign-issue-submit");
        this.flushMailQueueAndWait(1);
    }

    private void reopenIssue(String key, String comment, String security) throws InterruptedException {
        this.doWorkflow(key, 3, comment, security);
    }

    private void resolveIssue(String key, String comment, String security) throws InterruptedException {
        this.doWorkflow(key, 5, comment, security);
    }

    private void doWorkflow(String key, int id, String comment, String security) throws InterruptedException {
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLink("action_id_" + id);
        this.tester.setWorkingForm("issue-workflow-transition");
        if (comment != null) {
            this.tester.setFormElement("comment", comment);
        }
        if (security != null) {
            this.tester.selectOption("commentLevel", security);
        }
        this.tester.submit("Transition");
        this.flushMailQueueAndWait(1);
    }

    private String createGroupComment(String comment) {
        return GROUP_PRIVATE + comment;
    }

    private String createRoleComment(String comment) {
        return ROLE_PRIVATE + comment;
    }

    private void assertMessageAndType(MimeMessage message, String expectedComment, boolean html) {
        String body = GreenMailUtil.getBody((Part)message);
        TestNotificationEmails.assertTrue((body.contains("<html>") == html ? 1 : 0) != 0);
        this.assertTextSequence(body, expectedComment);
    }

    private void assertNotMessageAndType(MimeMessage message, String expectedComment, boolean html) {
        String body = GreenMailUtil.getBody((Part)message);
        TestNotificationEmails.assertTrue((body.contains("<html>") == html ? 1 : 0) != 0);
        this.assetTextNotPresent(body, expectedComment);
    }

    private void assetTextNotPresent(String text, String notPresent) {
        this.assertions.getTextAssertions().assertTextNotPresent(text, notPresent);
    }

    private void assertTextSequence(String text, String ... sequence) {
        this.assertions.getTextAssertions().assertTextSequence(text, sequence);
    }

    private MailBox getMailBox(String email) throws FolderException {
        return new MailBox(this.getUserInbox(email), email);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MailBox {
        private final MailFolder folder;
        private final String userEmail;
        private int pos;

        public MailBox(MailFolder folder, String userEmail) {
            this.folder = folder;
            this.userEmail = userEmail;
        }

        public MimeMessage nextMessage() {
            List<SimpleStoredMessage> messages = this.getMessages();
            if (this.pos >= messages.size()) {
                return null;
            }
            return messages.get(this.pos++).getMimeMessage();
        }

        private List<SimpleStoredMessage> getMessages() {
            return this.folder.getMessages();
        }

        public int size() {
            return this.folder.getMessageCount();
        }

        public void clear() {
            this.folder.deleteAllMessages();
            this.pos = 0;
        }

        public MimeMessage awaitMessage() {
            return this.awaitMessage(1000L);
        }

        public MimeMessage awaitMessage(long timeout) {
            MimeMessage message = this.nextMessage();
            long startTime = System.currentTimeMillis();
            if (message == null) {
                long timeoutTime = timeout + startTime;
                long currentTime = startTime;
                while (currentTime < timeoutTime && message == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    message = this.nextMessage();
                    currentTime = System.currentTimeMillis();
                }
            }
            if (message == null) {
                Assert.fail((String)("Waited '" + (System.currentTimeMillis() - startTime) + "' ms for e-mail to '" + this.userEmail + "' but got nothing."));
            }
            return message;
        }
    }
}

