/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestBulkDeleteIssuesNotifications
extends EmailFuncTestCase {
    public void testBulkDeleteNoNotifications() throws InterruptedException {
        this.administration.restoreData("TestBulkDeleteIssuesNotifications.xml");
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(false, false);
        this.flushMailQueueAndWait(0);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkDeleteIssuesNotifications.assertEquals((int)0, (int)mimeMessages.length);
    }

    public void testBulkDeleteNotifications() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestBulkDeleteIssuesNotifications.xml");
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(true, false);
        this.flushMailQueueAndWait(2);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkDeleteIssuesNotifications.assertEquals((int)2, (int)mimeMessages.length);
        this.assertRecipientsHaveMessages(EasyList.build((Object)"admin@example.com", (Object)"fred@example.com"));
    }

    public void testBulkDeleteSubtaskNoNotifications() throws InterruptedException {
        this.administration.restoreData("TestBulkDeleteIssuesNotificationsWithSubtasks.xml");
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(false, true);
        this.flushMailQueueAndWait(0);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkDeleteIssuesNotifications.assertEquals((int)0, (int)mimeMessages.length);
    }

    public void testBulkDeleteSubtaskNotifications() throws InterruptedException, MessagingException {
        this.administration.restoreData("TestBulkDeleteIssuesNotificationsWithSubtasks.xml");
        this.configureAndStartSmtpServer();
        this.bulkDeleteAllIssues(true, true);
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkDeleteIssuesNotifications.assertEquals((int)3, (int)mimeMessages.length);
        this.assertRecipientsHaveMessages(EasyList.build((Object)"admin@example.com", (Object)"fred@example.com"));
        HashSet<String> subjects = new HashSet<String>();
        List<MimeMessage> adminMessages = this.getMessagesForRecipient("admin@example.com");
        for (MimeMessage mimeMessage : adminMessages) {
            subjects.add(mimeMessage.getSubject());
        }
        TestBulkDeleteIssuesNotifications.assertEquals((int)2, (int)subjects.size());
        TestBulkDeleteIssuesNotifications.assertTrue((boolean)subjects.contains("[JIRATEST] Deleted: (HSP-2) This is my bug"));
        TestBulkDeleteIssuesNotifications.assertTrue((boolean)subjects.contains("[JIRATEST] Deleted: (HSP-4) Subtask1"));
        List<MimeMessage> fredMessages = this.getMessagesForRecipient("fred@example.com");
        this.assertEmailSubjectEquals(fredMessages.get(0), "[JIRATEST] Deleted: (HSP-3) This is fred's bug");
    }

    private void bulkDeleteAllIssues(boolean sendMail, boolean subtaskPresent) {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.setFormElement("operation", "bulk.delete.operation.name");
        this.tester.submit("Next");
        if (!sendMail) {
            this.tester.uncheckCheckbox("sendBulkNotification");
        }
        this.tester.submit("Next");
        if (!sendMail) {
            this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"Email notifications will", "NOT", "be sent for this update."});
        } else {
            this.tester.assertTextPresent("Email notifications will be sent for this update.");
        }
        if (subtaskPresent) {
            this.tester.assertTextPresent("Subtask1");
        } else {
            this.tester.assertTextNotPresent("Subtask1");
        }
        this.tester.submit("Confirm");
        this.tester.assertTextPresent("No matching issues found.");
    }
}

