/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestSingleLevelGroupByReport
extends JIRAWebTest {
    public TestSingleLevelGroupByReport(String name) {
        super(name);
    }

    public void testRunReportLoggedIn() {
        this.restoreData("TestFullAnonymousPermissions.xml");
        this.login("admin", "admin");
        this.runReport();
    }

    public void testRunReportAnonymously() {
        this.restoreData("TestFullAnonymousPermissions.xml");
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.runReport();
    }

    public void runReport() {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.assertTextPresent("Select a filter to display");
        this.assertTextPresent("Select a field to group by");
        this.setFormElement("filterid", "10000");
        this.submit("Next");
        this.assertTextPresent("Single Level Group By Report");
        this.assertTextPresent("MKY-2");
        this.assertTextPresent("MKY-1");
        this.assertTextPresent("0 of 2 issues have been resolved");
    }

    public void testVersionIsEncoded() {
        this.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertTextPresent("&quot;version&lt;input &gt;");
        this.assertTextNotPresent("\"version<input >");
    }

    public void testFieldVisibility() {
        this.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.gotoFieldConfigurationDefault();
        this.clickLink("hide_12");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, true);
        this.gotoFieldConfigurationDefault();
        this.clickLink("hide_14");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, false);
        this.gotoFieldConfigurationDefault();
        this.clickLink("show_12");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, false);
        this.gotoFieldConfigurationDefault();
        this.clickLink("show_14");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.createIssueStep1("homosapien", "Improvement");
        this.setFormElement("summary", "This is a test to see if field is shown");
        this.submit();
        this.gotoAdmin();
        this.clickLink("field_configuration");
        this.setFormElement("fieldLayoutName", "Many Hidden Fields");
        this.submit("Add");
        this.clickLink("configure-Many Hidden Fields");
        this.clickLink("hide_4");
        this.clickLink("hide_8");
        this.clickLink("hide_12");
        this.clickLink("hide_14");
        this.clickLink("issue_fields");
        this.setFormElement("fieldLayoutSchemeName", "All Fields Hidden Scheme");
        this.submit("Add");
        this.clickLinkWithText("Configure");
        this.selectOption("issueTypeId", "Bug");
        this.selectOption("fieldConfigurationId", "Many Hidden Fields");
        this.submit("Add");
        this.clickLink("view_projects");
        this.clickLinkWithText("homosapien");
        this.clickLink("select_fieldlayoutscheme");
        this.selectOption("schemeId", "All Fields Hidden Scheme");
        this.submit("Associate");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisibleEnt();
    }

    public void testFilterIdRequired() {
        this.restoreBlankInstance();
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.submit("Next");
        this.assertTextPresent("Filter is a required field");
    }

    private void gotoSinglelevelGroupByReportAllFixForVersions() {
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.setFormElement("filterid", "10000");
        this.selectOption("mapper", "Fix For Versions (all)");
        this.submit("Next");
    }

    private void assertFieldsVisibleEnt() {
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)9, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 5);
                if (i == 8) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 3);
                if (i == 8) {
                    TestSingleLevelGroupByReport.assertTrue((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertFieldsVisible(boolean priorityVisible, boolean resolutionVisible) {
        try {
            WebTable table = this.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)7, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 5);
                if (priorityVisible) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 3);
                if (resolutionVisible) {
                    TestSingleLevelGroupByReport.assertTrue((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }
}

