/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestDeveloperWorkloadReportPermissions
extends JIRAWebTest {
    private final Report report = new Report();

    public TestDeveloperWorkloadReportPermissions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestDeveloperWorkloadReportPermissions.xml");
    }

    public void test() {
        this.login("admin", "admin");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        Object tests = new AdminLoginTests();
        ((AdminLoginTests)tests).testFredUser();
        ((AdminLoginTests)tests).testFredUserWithSubTasks();
        ((AdminLoginTests)tests).testBobUser();
        ((AdminLoginTests)tests).testBobUserWithSubTasks();
        this.login("fred", "fred");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        tests = new FredLoginTests();
        ((FredLoginTests)tests).testFredUser();
        ((FredLoginTests)tests).testFredUserWithSubTasks();
        ((FredLoginTests)tests).testBobUser();
        ((FredLoginTests)tests).testBobUserWithSubTasks();
        this.login("bob", "bob");
        this._testAdminUserDeveloperWorkloadReportAdminLogin();
        tests = new BobLoginTests();
        ((BobLoginTests)tests).testFredUser();
        ((BobLoginTests)tests).testFredUserWithSubTasks();
        ((BobLoginTests)tests).testBobUser();
        ((BobLoginTests)tests).testBobUserWithSubTasks();
    }

    private void _testAdminUserDeveloperWorkloadReportAdminLogin() {
        this.report.generateWithoutSubtasks("admin");
        this.assertTextPresent("User Workload Report");
        this.assertTextPresent("There are no unresolved issues assigned to the specified user");
    }

    private class Report {
        private static final String REPORT = "secure/ConfigureReport.jspa?reportKey=com.atlassian.jira.plugin.system.reports%3Adeveloper-workload&Next=Next";
        private static final String CONFIG = "/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.plugin.system.reports:developer-workload";

        private Report() {
        }

        void configure() {
            TestDeveloperWorkloadReportPermissions.this.gotoPage(CONFIG);
        }

        void generate(String user, String subtaskInclusion) {
            TestDeveloperWorkloadReportPermissions.this.gotoPage("secure/ConfigureReport.jspa?reportKey=com.atlassian.jira.plugin.system.reports%3Adeveloper-workload&Next=Next&developer=" + user + "&subtaskInclusion=" + subtaskInclusion);
        }

        void generateWithoutSubtasks(String user) {
            this.generate(user, "onlyAssigned");
        }

        void generateWithUnassignedSubtasks(String user) {
            this.generate(user, "assignedAndUnassigned");
        }
    }

    class BobLoginTests {
        BobLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "2", "3 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "2", "3 days, 6 hours"});
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "2", "3 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "2", "3 days, 6 hours"});
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "9", "4 days, 5 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "9", "4 days, 5 hours"});
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "10", "1 week, 4 days, 1 hour"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "10", "1 week, 4 days, 1 hour"});
        }
    }

    class FredLoginTests {
        FredLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "8", "1 week, 4 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "8", "1 week, 4 days, 6 hours"});
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "8", "1 week, 4 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "8", "1 week, 4 days, 6 hours"});
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "3", "3 days, 7 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "3", "3 days, 7 hours"});
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "4", "1 week, 3 days, 3 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "4", "1 week, 3 days, 3 hours"});
        }
    }

    class AdminLoginTests {
        AdminLoginTests() {
        }

        private void testFredUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "8", "1 week, 4 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "8", "1 week, 4 days, 6 hours"});
        }

        private void testFredUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("fred");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Fred Normal");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "8", "1 week, 4 days, 6 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "8", "1 week, 4 days, 6 hours"});
        }

        private void testBobUser() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithoutSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "9", "4 days, 5 hours"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "9", "4 days, 5 hours"});
        }

        private void testBobUserWithSubTasks() {
            TestDeveloperWorkloadReportPermissions.this.report.generateWithUnassignedSubtasks("bob");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("User Workload Report");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Workload report for user");
            TestDeveloperWorkloadReportPermissions.this.assertTextPresent("Bob The Builder");
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"homosapien", "10", "1 week, 4 days, 1 hour"});
            TestDeveloperWorkloadReportPermissions.this.assertTextSequence(new String[]{"Total", "10", "1 week, 4 days, 1 hour"});
        }
    }
}

