/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.ArrayList;

public class TestCascadingSelectCustomField
extends JIRAWebTest {
    private static final String CUSTOMFIELD_10000 = "customfield_10000";
    private static final String CUSTOMFIELD_10000_OPTION = "customfield_10000:1";
    private static final String CUSTOMFIELD_10000_1 = "customfield_10000:1";
    private static final String CASCADING_SELECT_NAME = "asdf";
    private static final String UPDATE_FIELD_TEXT = "Update the fields of the issue to relate to the new project.";
    private static final String ERROR_PRESENT_FOR_BAD_OPTION = "The option 'a1' is invalid for parent option 'test'";
    private static final String HOMO_PID_OPTION = "10001_1_pid";
    private static final String MONKEY_PID_OPTION = "10000_1_pid";
    private static final String MOVE_ISSUES_CONFIRMATION_TEXT = "Move Issues: Confirmation";

    public TestCascadingSelectCustomField(String name) {
        super(name);
    }

    public void testMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("move-issue");
        this.setFormElement("pid", "10001");
        this.submit("Next >>");
        this.assertTextPresent(UPDATE_FIELD_TEXT);
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "t1");
        this.submit("Next >>");
        this.assertTextPresent("stuff");
        this.assertTextPresent("s1");
        this.assertTextPresent("test");
        this.assertTextPresent("t1");
        this.submit("Move");
        this.assertTextPresent("test");
        this.assertTextPresent("t1");
    }

    public void testMoveIssueWithCascadingSelectCustomFieldWithBadValues() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("move-issue");
        this.setFormElement("pid", "10001");
        this.submit("Next >>");
        this.assertTextPresent(UPDATE_FIELD_TEXT);
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "a1");
        this.submit("Next >>");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded(ERROR_PRESENT_FOR_BAD_OPTION);
    }

    public void testBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts() {
        this.restoreData("TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.selectOption(MONKEY_PID_OPTION, "monkey");
        this.selectOption(HOMO_PID_OPTION, "homosapien");
        this.submit("Next");
        this.selectOption(CUSTOMFIELD_10000, "test");
        this.selectOption("customfield_10000:1", "t1");
        this.submit("Next");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Next");
        this.assertTextPresent(MOVE_ISSUES_CONFIRMATION_TEXT);
    }

    public void testEditIssueWithCascadingSelectField() {
        this.restoreData("TestBulkMoveWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoIssue("HSP-1");
        this.clickLink("editIssue");
        this.selectOption(CUSTOMFIELD_10000, "cranky");
        this.selectOption("customfield_10000:1", "p1");
        this.submit("Update");
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.assertTextPresent("cranky");
        this.assertTextPresent("p1");
        this.clickLink("editIssue");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "p1");
        this.submit("Update");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("The option 'p1' is invalid for parent option 'stuff'");
    }

    public void testCreateIssueWithCascadingSelect() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "cranky");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("The option 's1' is invalid for parent option 'cranky'");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "s1");
        this.submit("Create");
        this.assertTextPresent(CASCADING_SELECT_NAME);
        this.assertTextPresent("stuff");
        this.assertTextPresent("s1");
    }

    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForParent() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "None");
        this.submit("Create");
        this.assertTextNotPresent("asdf:");
    }

    public void testCreateIssueWithCascadingSelectChoosingOptionsNoneForChild() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.createIssueStep1();
        this.setFormElement("summary", "Test summary");
        this.selectOption(CUSTOMFIELD_10000, "stuff");
        this.selectOption("customfield_10000:1", "None");
        this.submit("Create");
        this.assertTextPresent("stuff");
    }

    public void testSetDefaultNoneOptionsForCascadingSelect() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("config_customfield_10000");
        this.clickLinkWithText("Edit Default Value");
        this.selectOption(CUSTOMFIELD_10000, "None");
        this.submit();
    }

    public void testIssueNavigatorSearchCascadingSelectWithAllOption() {
        this.restoreData("TestMoveIssueWithCascadingSelectCustomFieldWithDifferentContexts.xml");
        this.clickLink("find_link");
        this.selectOption("pid", "homosapien");
        this.submit("show");
        this.selectOption(CUSTOMFIELD_10000, "Any");
        this.submit("show");
        this.assertTextPresent("This is a test bug for the subversion plugin");
    }

    public void testDeleteOptionFromFieldAtFirstLevelOnTheIssue() {
        this.restoreData("TestDeleteOptionFromCascadingSelectCustomField.xml");
        this.removeOptions("10000", "Option_A", "HSP-1");
        this.assertTextPresent("Edit Custom Field Options");
        this.assertTextNotPresent("Option_A");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertElementNotPresent("rowForcustomfield_10000");
    }

    public void testDeleteOptionFromFieldAtSecondLevelOnTheIssue() {
        this.restoreData("TestDeleteOptionFromCascadingSelectCustomField.xml");
        this.removeSubOptions(10000L, "Option_B", "Option B-B", "HSP-3");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//*[@class='instructions']"), "with parent option Option_B");
        this.assertTextPresent("There are currently no options available for this select list");
        this.navigation.issue().viewIssue("HSP-3");
        this.text.assertTextPresent(new IdLocator(this.tester, "customfield_10000-val"), "Option_B");
    }

    public void testDeleteOptionFromFieldAtFirstLevelWithSubOptions() {
        this.restoreData("TestDeleteOptionFromCascadingSelectCustomField.xml");
        this.removeOptions("10000", "Option_B", "HSP-3");
        this.assertTextPresent("Edit Custom Field Options");
        this.assertTextNotPresent("Option_B");
        this.navigation.issue().viewIssue("HSP-3");
        this.assertElementNotPresent("rowForcustomfield_10000");
    }

    public void testDeleteOptionFromFieldWithNoAssociatedIssues() {
        this.restoreData("TestDeleteOptionFromCascadingSelectCustomField.xml");
        this.removeOptions("10000", "Option_C", null);
        this.assertTextPresent("Edit Custom Field Options");
        this.assertTextNotPresent("Option_C");
    }

    private void removeOptions(String numericCustomFieldId, String options, String issueAffected) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + numericCustomFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLink("del_" + options);
        this.assertRemoveOptionConfirmationScreen(issueAffected);
        this.tester.submit("Delete");
    }

    private void removeSubOptions(Long customFieldId, String parentOption, String optionToRemove, String issueAffected) {
        this.tester.gotoPage("/secure/admin/ConfigureCustomField!default.jspa?customFieldId=" + customFieldId);
        this.tester.clickLinkWithText("Edit Options");
        this.tester.clickLinkWithText(parentOption);
        this.tester.clickLink("del_" + optionToRemove);
        this.assertRemoveOptionConfirmationScreen(issueAffected);
        this.tester.submit("Delete");
    }

    private void assertRemoveOptionConfirmationScreen(String issueAffected) {
        String issueCount = issueAffected == null ? "0" : "1";
        ArrayList<String> textSequence = new ArrayList<String>();
        textSequence.add("Issues with this value");
        textSequence.add(issueCount);
        if (issueAffected != null) {
            textSequence.add(issueAffected);
        }
        this.text.assertTextSequence(new WebPageLocator(this.tester), textSequence.toArray(new String[textSequence.size()]));
    }
}

