/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestWorklogResource
extends RestFuncTest {
    public void testViewWorklog() throws Exception {
        WebResponse response = this.GET("rest/api/2.0.alpha1/worklog/10000");
        JSONObject worklog = new JSONObject(response.getText());
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/worklog/10000"), (String)worklog.getString("self"));
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/issue/HSP-1"), (String)worklog.getString("issue"));
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=admin"), (String)worklog.getJSONObject("author").getString("self"));
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.getJSONObject("author").getString("name"));
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.getJSONObject("author").getString("displayName"));
        TestWorklogResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=admin"), (String)worklog.getJSONObject("updateAuthor").getString("self"));
        TestWorklogResource.assertEquals((String)"admin", (String)worklog.getJSONObject("updateAuthor").getString("name"));
        TestWorklogResource.assertEquals((String)"Administrator", (String)worklog.getJSONObject("updateAuthor").getString("displayName"));
        TestWorklogResource.assertEquals((String)"", (String)worklog.getString("comment"));
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", worklog.getString("created"));
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", worklog.getString("updated"));
        this.assertEqualDateStrings("2010-05-24T09:52:00.000+1000", worklog.getString("started"));
        TestWorklogResource.assertEquals((long)120L, (long)worklog.getLong("minutesSpent"));
    }

    public void testViewWorklogNotFound() throws Exception {
        WebResponse response123 = this.GET("rest/api/2.0.alpha1/worklog/123");
        TestWorklogResource.assertEquals((int)404, (int)response123.getResponseCode());
        JSONObject content123 = new JSONObject(response123.getText());
        TestWorklogResource.assertEquals((int)1, (int)content123.getJSONArray("errorMessages").length());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: '123'.", (String)content123.getJSONArray("errorMessages").getString(0));
        WebResponse responseAbc = this.GET("rest/api/2.0.alpha1/worklog/abc");
        TestWorklogResource.assertEquals((int)404, (int)responseAbc.getResponseCode());
        JSONObject contentAbc = new JSONObject(responseAbc.getText());
        TestWorklogResource.assertEquals((int)1, (int)contentAbc.getJSONArray("errorMessages").length());
        TestWorklogResource.assertEquals((String)"Cannot find worklog with id: 'abc'.", (String)contentAbc.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
    }
}

