/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.meterware.httpunit.WebResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUserResource
extends RestFuncTest {
    private static final String USER_PATH = "user";
    private static final String REST_PATH = "rest/api/2.0.alpha1";
    private static final String REST_USER_URL = "rest/api/2.0.alpha1/user";

    public void testUserResourceNoUsername() throws Exception {
        WebResponse response = this.GET(REST_USER_URL);
        TestUserResource.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestUserResource.assertEquals((Object)"The username query parameter was not provided", (Object)json.getJSONArray("errorMessages").get(0));
    }

    public void testUserResourceForUserThatDoesntExist() throws Exception {
        WebResponse response = this.GET(this.getPathFor("bofh"));
        TestUserResource.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestUserResource.assertEquals((Object)"The user named 'bofh' does not exist", (Object)json.getJSONArray("errorMessages").get(0));
    }

    public void testUserResourceGroupsNotExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        JSONObject user = this.getJSON(userPath, new String[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.getString("self"));
        TestUserResource.assertTrue((boolean)user.has("groups"));
        TestUserResource.assertTrue((boolean)user.has("expand"));
        TestUserResource.assertEquals((String)"groups", (String)user.getString("expand"));
        JSONObject groups = user.getJSONObject("groups");
        TestUserResource.assertTrue((boolean)groups.has("size"));
        TestUserResource.assertEquals((long)1L, (long)groups.getLong("size"));
        TestUserResource.assertTrue((boolean)groups.has("items"));
        TestUserResource.assertTrue((groups.getJSONArray("items").length() == 0 ? 1 : 0) != 0);
    }

    public void testUserResourceGroupsExpanded() throws Exception {
        String username = "fred";
        String userPath = this.getPathFor("fred");
        JSONObject user = this.getJSON(this.getPathFor("fred", Collections.singletonMap("expand", "groups")), new String[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.getString("self"));
        TestUserResource.assertTrue((boolean)user.has("groups"));
        JSONObject groups = user.getJSONObject("groups");
        TestUserResource.assertTrue((boolean)groups.has("size"));
        TestUserResource.assertEquals((long)1L, (long)groups.getLong("size"));
        TestUserResource.assertTrue((boolean)groups.has("items"));
        TestUserResource.assertTrue((groups.getJSONArray("items").length() == 1 ? 1 : 0) != 0);
        TestUserResource.assertEquals((String)"jira-users", (String)groups.getJSONArray("items").getJSONObject(0).getString("name"));
    }

    public void testGetAnonymouslyUserResource() throws Exception {
        this.navigation.logout();
        TestUserResource.assertError(401, this.GET("rest/api/2.0.alpha1/user?username=fred"));
    }

    public void testUnicodeCharacters() throws Exception {
        String username = "\u611b";
        String userPath = this.getPathFor("%E6%84%9B");
        JSONObject user = this.getJSON(userPath, new String[0]);
        TestUserResource.assertEquals((String)this.getBaseUrlPlus(userPath), (String)user.getString("self"));
        TestUserResource.assertEquals((String)"\u611b", (String)user.getString("name"));
        TestUserResource.assertEquals((String)"\u611b \u6237", (String)user.getString("displayName"));
        TestUserResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=%E6%84%9B"), (String)user.getString("self"));
        TestUserResource.assertEquals((String)this.getBaseUrlPlus("secure/useravatar?size=large&ownerId=%E6%84%9B"), (String)user.getString("avatarUrl"));
    }

    public void testUsernamesWithInterestingCharacters() throws Exception {
        this.assertUserRepresentationIsOK("a\\b", "a%5Cb");
        this.assertUserRepresentationIsOK("c/d", "c/d");
        this.assertUserRepresentationIsOK("sp ace", "sp+ace");
        this.assertUserRepresentationIsOK("pl+us", "pl%2Bus");
        this.assertUserRepresentationIsOK("per%cent", "per%25cent");
        this.assertUserRepresentationIsOK("\u611b", "%E6%84%9B");
    }

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestUserResource.xml");
    }

    protected String getPathFor(String username) {
        return this.getPathFor(username, Collections.emptyMap());
    }

    private void assertUserRepresentationIsOK(String username, String encodedUsername) throws JSONException {
        String userPath = this.getPathFor(encodedUsername);
        JSONObject user = this.getJSON(userPath, new String[0]);
        TestUserResource.assertEquals((String)username, (String)user.getString("name"));
        TestUserResource.assertEquals((String)"The username is not encoded in the self link", (String)this.getBaseUrlPlus("rest/api/2.0.alpha1/user?username=" + encodedUsername), (String)user.getString("self"));
        TestUserResource.assertEquals((String)"The username is not encoded in the avatar URL", (String)this.getBaseUrlPlus("secure/useravatar?size=large&ownerId=" + encodedUsername), (String)user.getString("avatarUrl"));
    }

    protected String getPathFor(String username, Map<?, ?> queryParams) {
        return "rest/api/2.0.alpha1/user?username=" + username + StringUtils.join((Collection)Collections2.transform(queryParams.entrySet(), (Function)new Function<Map.Entry, Object>(){

            public Object apply(Map.Entry from) {
                return String.format("&%s=%s", from.getKey(), from.getValue());
            }
        }), (String)"");
    }
}

