/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestResolutionResource
extends RestFuncTest {
    public void testViewResolution() throws Exception {
        JSONObject resolution = this.getJSON("rest/api/2.0.alpha1/resolution/2", new String[0]);
        TestResolutionResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/resolution/2"), (String)resolution.getString("self"));
        TestResolutionResource.assertEquals((String)"The problem described is an issue which will never be fixed.", (String)resolution.getString("description"));
        TestResolutionResource.assertEquals((String)"Won't Fix", (String)resolution.getString("name"));
    }

    public void testViewResolutionNotFound() throws Exception {
        WebResponse resp = this.GET("rest/api/2.0.alpha1/resolution/999");
        TestResolutionResource.assertEquals((int)404, (int)resp.getResponseCode());
        JSONObject jsonResp = new JSONObject(resp.getText());
        TestResolutionResource.assertEquals((String)"The resolution with id '999' does not exist", (String)jsonResp.getJSONArray("errorMessages").getString(0));
        resp = this.GET("rest/api/2.0.alpha1/resolution/boom");
        TestResolutionResource.assertEquals((int)404, (int)resp.getResponseCode());
        jsonResp = new JSONObject(resp.getText());
        TestResolutionResource.assertEquals((String)"The resolution with id 'boom' does not exist", (String)jsonResp.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }
}

