/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestIssueTypeResource
extends RestFuncTest {
    private static final String TASK_ISSUE_TYPE_ID = "3";

    public void testIssueTypeVisible() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issueType/3");
        JSONObject issueType = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issueType/" + TASK_ISSUE_TYPE_ID), (String)issueType.getString("self"));
        TestIssueTypeResource.assertEquals((String)"A task that needs to be done.", (String)issueType.getString("description"));
        TestIssueTypeResource.assertEquals((String)(this.getBaseUrl() + "/images/icons/task.gif"), (String)issueType.getString("iconUrl"));
        TestIssueTypeResource.assertEquals((String)"Task", (String)issueType.getString("name"));
        TestIssueTypeResource.assertEquals((boolean)false, (boolean)issueType.getBoolean("subtask"));
    }

    public void testIssueTypeNotFound() throws Exception {
        this.navigation.login("fred");
        WebResponse response = this.GET("rest/api/2.0.alpha1/issueType/3");
        JSONObject json = new JSONObject(response.getText());
        TestIssueTypeResource.assertEquals((String)"The issue type with id '3' does not exist", (String)json.getJSONArray("errorMessages").getString(0));
        response = this.GET("rest/api/2.0.alpha1/issueType/zzz");
        TestIssueTypeResource.assertEquals((int)404, (int)response.getResponseCode());
        json = new JSONObject(response.getText());
        TestIssueTypeResource.assertEquals((String)"The issue type with id 'zzz' does not exist", (String)json.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueTypeResource.xml");
    }
}

