/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestIssueResourceVotes
extends RestFuncTest {
    String issueKey;
    String issueREST;

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Issue for voting test");
        this.issueREST = String.format("/rest/api/2.0.alpha1/issue/%s", this.issueKey);
        this.navigation.login("fred");
        this.navigation.issue().voteIssue(this.issueKey);
        this.navigation.login("admin");
    }

    public void testVote_issueDoesNotExist() throws Exception {
        this.navigation.login("fred");
        WebResponse response = this.DELETE("/rest/api/2.0.alpha1/issue/HSP-204/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Issue Does Not Exist", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testVote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        this.administration.usersAndGroups().addUser("barney");
        this.navigation.login("barney");
        WebResponse response = this.DELETE(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Voting for issues is currently not enabled for this JIRA instance.", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testVote_reporter() throws Exception {
        WebResponse response = this.POST(this.issueREST + "/votes", new JSONObject());
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"You cannot vote for an issue you have reported.", (String)json.getJSONArray("errorMessages").getString(0));
        TestIssueResourceVotes.assertEquals((int)1, (int)this.getVotes());
        TestIssueResourceVotes.assertFalse((boolean)this.i_voted());
    }

    public void testVote_successful() throws Exception {
        this.administration.usersAndGroups().addUser("barney");
        this.navigation.login("barney");
        WebResponse response = this.POST(this.issueREST + "/votes", new JSONObject());
        TestIssueResourceVotes.assertEquals((int)204, (int)response.getResponseCode());
        TestIssueResourceVotes.assertEquals((int)2, (int)this.getVotes());
        TestIssueResourceVotes.assertTrue((boolean)this.i_voted());
    }

    public void testViewVoters_issueDoesNotExist() throws Exception {
        WebResponse response = this.GET("/rest/api/2.0.alpha1/issue/HSP-55/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Issue Does Not Exist", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testViewVoters_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        WebResponse response = this.GET(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Voting for issues is currently not enabled for this JIRA instance.", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testViewVoters_noPermission() throws Exception {
        this.navigation.login("fred");
        WebResponse response = this.GET(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)200, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((int)1, (int)json.getInt("votes"));
        JSONArray voters = json.getJSONArray("voters");
        TestIssueResourceVotes.assertEquals((int)0, (int)voters.length());
    }

    public void testViewVoters_successful() throws Exception {
        WebResponse response = this.GET(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)200, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((int)1, (int)json.getInt("votes"));
        JSONObject user = json.getJSONArray("voters").getJSONObject(0);
        TestIssueResourceVotes.assertTrue((boolean)user.has("self"));
        TestIssueResourceVotes.assertEquals((String)"fred", (String)user.getString("name"));
        TestIssueResourceVotes.assertEquals((String)"Fred Normal", (String)user.getString("displayName"));
    }

    public void testUnvote_issueDoesNotExist() throws Exception {
        this.navigation.login("fred");
        WebResponse response = this.DELETE("/rest/api/2.0.alpha1/issue/HSP-204/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Issue Does Not Exist", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testUnvote_votingDisabled() throws Exception {
        this.administration.generalConfiguration().disableVoting();
        this.navigation.login("fred");
        WebResponse response = this.DELETE(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"Voting for issues is currently not enabled for this JIRA instance.", (String)json.getJSONArray("errorMessages").getString(0));
    }

    public void testUnvote_reporter() throws Exception {
        WebResponse response = this.DELETE(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)404, (int)response.getResponseCode());
        JSONObject json = new JSONObject(response.getText());
        TestIssueResourceVotes.assertEquals((String)"You cannot vote for an issue you have reported.", (String)json.getJSONArray("errorMessages").getString(0));
        TestIssueResourceVotes.assertEquals((int)1, (int)this.getVotes());
    }

    public void testUnvote_successful() throws Exception {
        this.navigation.login("fred");
        WebResponse response = this.DELETE(this.issueREST + "/votes");
        TestIssueResourceVotes.assertEquals((int)204, (int)response.getResponseCode());
        TestIssueResourceVotes.assertEquals((int)0, (int)this.getVotes());
        TestIssueResourceVotes.assertFalse((boolean)this.i_voted());
    }

    private int getVotes() throws JSONException {
        return this.getJSON(this.issueREST, new String[0]).getJSONObject("fields").getJSONObject("votes").getJSONObject("value").getInt("votes");
    }

    private boolean i_voted() throws JSONException {
        return this.getJSON(this.issueREST, new String[0]).getJSONObject("fields").getJSONObject("votes").getJSONObject("value").getBoolean("hasVoted");
    }
}

