/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.io.IOException;
import java.util.Collections;

public class TestIssueResourceTimeTracking
extends FuncTestCase {
    private static final String FIELDS_KEY = "fields";
    private static final String TIME_TRACKING_KEY = "timetracking";
    private static final String ORIGINAL_ESTIMATE_KEY = "timeoriginalestimate";
    private static final String ESTIMATE_KEY = "timeestimate";
    private static final String TIME_SPENT_KEY = "timespent";

    public void testTimeTrackingDisabled() throws Exception {
        this.restoreData(false);
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/FUNC-3");
        JSONObject jsonFields = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject(FIELDS_KEY);
        try {
            jsonFields.getJSONObject(TIME_TRACKING_KEY);
            TestIssueResourceTimeTracking.fail((String)"timetracking shouldn't be in response when time tracking is disabled");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testIssueWithNoTimeTracking() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/FUNC-1");
        JSONObject jsonFields = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject(FIELDS_KEY);
        try {
            jsonFields.getJSONObject(TIME_TRACKING_KEY);
            TestIssueResourceTimeTracking.fail((String)"timetracking shouldn't exist for FUNC-1");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testIssueWithOriginalEstimate() throws Exception {
        this.restoreData(true);
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/FUNC-3");
        JSONObject jsonFields = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject(FIELDS_KEY);
        TestIssueResourceTimeTracking.assertNotNull((Object)jsonFields.getJSONObject(TIME_TRACKING_KEY));
        TestIssueResourceTimeTracking.assertEquals((long)1440L, (long)jsonFields.getJSONObject(TIME_TRACKING_KEY).getJSONObject("value").getLong(ORIGINAL_ESTIMATE_KEY));
    }

    public void testIssueWithTimeSpent() throws Exception {
        this.restoreData(true);
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/FUNC-3");
        JSONObject jsonFields = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject(FIELDS_KEY);
        TestIssueResourceTimeTracking.assertNotNull((Object)jsonFields.getJSONObject(TIME_TRACKING_KEY));
        TestIssueResourceTimeTracking.assertEquals((long)480L, (long)jsonFields.getJSONObject(TIME_TRACKING_KEY).getJSONObject("value").getLong(TIME_SPENT_KEY));
    }

    public void testIssueWithTimeRemaining() throws Exception {
        this.restoreData(true);
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/FUNC-3");
        JSONObject jsonFields = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject(FIELDS_KEY);
        TestIssueResourceTimeTracking.assertNotNull((Object)jsonFields.getJSONObject(TIME_TRACKING_KEY));
        TestIssueResourceTimeTracking.assertEquals((long)960L, (long)jsonFields.getJSONObject(TIME_TRACKING_KEY).getJSONObject("value").getLong(ESTIMATE_KEY));
    }

    protected void restoreData(boolean timeTrackingEnabled) throws IOException {
        this.administration.restoreDataWithReplacedTokens("TestIssueResourceTimeTracking.xml", Collections.singletonMap("@@TIMETRACKING@@", timeTrackingEnabled ? "1" : "0"));
    }
}

