/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;

public class TestIssueResourceSubtasks
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestIssueResourceSubtasks.xml");
    }

    public void testSubtaskLink() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1");
        JSONObject issue = new JSONObject(this.tester.getDialog().getResponseText());
        JSONArray subtasks = issue.getJSONObject("fields").getJSONObject("sub-tasks").getJSONArray("value");
        TestIssueResourceSubtasks.assertEquals((int)1, (int)subtasks.length());
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        JSONObject lnkHsp2 = subtasks.getJSONObject(0);
        TestIssueResourceSubtasks.assertEquals((String)"HSP-2", (String)lnkHsp2.getString("issueKey"));
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/HSP-2"), (String)lnkHsp2.getString("issue"));
        TestIssueResourceSubtasks.assertEquals((String)"Sub-Task", (String)lnkHsp2.getJSONObject("type").getString("name"));
    }

    public void testParentLink() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-2");
        JSONObject issue = new JSONObject(this.tester.getDialog().getResponseText());
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        JSONObject parent = issue.getJSONObject("fields").getJSONObject("parent").getJSONObject("value");
        TestIssueResourceSubtasks.assertEquals((String)"HSP-1", (String)parent.getString("issueKey"));
        TestIssueResourceSubtasks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)parent.getString("issue"));
        TestIssueResourceSubtasks.assertEquals((String)"Parent", (String)parent.getJSONObject("type").getString("name"));
    }
}

