/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.io.IOException;
import java.util.Collections;

public class TestIssueResourceIssueLinks
extends FuncTestCase {
    private static final String ISSUE_LINKS_KEY = "links";
    private static final String ISSUE_LINK_KEY_KEY = "issueKey";

    public void testIssueLinksDisabled() throws Exception {
        this.restoreData(false);
        JSONObject issue = this.getIssue("LNK-4");
        try {
            issue.getJSONArray(ISSUE_LINKS_KEY);
            TestIssueResourceIssueLinks.fail((String)"Issue links shouldn't be returned if links are disabled");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testNoIssueLinks() throws Exception {
        this.restoreData(true);
        JSONObject issue = this.getIssue("LNK-5");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no issue links", (int)0, (int)links.length());
    }

    public void testNoOutwardIssueLinks() throws Exception {
        this.restoreData(true);
        JSONObject issue = this.getIssue("LNK-1");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        for (int i = 0; i < links.length(); ++i) {
            JSONObject link = links.getJSONObject(i);
            TestIssueResourceIssueLinks.assertEquals((String)"INBOUND", (String)link.getJSONObject("type").getString("direction"));
        }
    }

    public void testNoVisibleLinks() throws Exception {
        this.restoreData(true);
        this.navigation.logout();
        this.navigation.login("reporter");
        JSONObject issue = this.getIssue("LNK-2");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        TestIssueResourceIssueLinks.assertEquals((String)"Object should have no visible issue links", (int)0, (int)links.length());
    }

    public void testInvisibleIssueNotShown() throws Exception {
        this.restoreData(true);
        this.navigation.logout();
        this.navigation.login("reporter");
        JSONObject issue = this.getIssue("LNK-4");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.length());
        TestIssueResourceIssueLinks.assertEquals((Object)"LNK-1", (Object)links.getJSONObject(0).get(ISSUE_LINK_KEY_KEY));
    }

    public void testSeveralIssueLinks() throws Exception {
        this.restoreData(true);
        JSONObject issue = this.getIssue("LNK-4");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        TestIssueResourceIssueLinks.assertEquals((int)2, (int)links.length());
        if ("LNK-1".equals(links.getJSONObject(0).get(ISSUE_LINK_KEY_KEY)) && "LNK-3".equals(links.getJSONObject(1).get(ISSUE_LINK_KEY_KEY))) {
            return;
        }
        if ("LNK-3".equals(links.getJSONObject(0).get(ISSUE_LINK_KEY_KEY)) && "LNK-1".equals(links.getJSONObject(1).get(ISSUE_LINK_KEY_KEY))) {
            return;
        }
        TestIssueResourceIssueLinks.fail((String)"Issue links LNK-1 and LNK-3 should both be visible");
    }

    public void testIssueLinkMetadataPresent() throws Exception {
        this.restoreData(true);
        this.navigation.logout();
        this.navigation.login("reporter");
        JSONObject issue = this.getIssue("LNK-6");
        JSONArray links = issue.getJSONObject("fields").getJSONObject(ISSUE_LINKS_KEY).getJSONArray("value");
        TestIssueResourceIssueLinks.assertEquals((int)1, (int)links.length());
        JSONObject linktoLnk1 = links.getJSONObject(0);
        String baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        TestIssueResourceIssueLinks.assertEquals((String)"LNK-1", (String)linktoLnk1.getString(ISSUE_LINK_KEY_KEY));
        TestIssueResourceIssueLinks.assertEquals((String)(baseUrl + "/rest/api/2.0.alpha1/issue/LNK-1"), (String)linktoLnk1.getString("issue"));
        TestIssueResourceIssueLinks.assertEquals((String)"Duplicate", (String)linktoLnk1.getJSONObject("type").getString("name"));
        TestIssueResourceIssueLinks.assertEquals((String)"OUTBOUND", (String)linktoLnk1.getJSONObject("type").getString("direction"));
        TestIssueResourceIssueLinks.assertEquals((String)"duplicates", (String)linktoLnk1.getJSONObject("type").getString("description"));
    }

    private JSONObject getIssue(String issueKey) throws JSONException {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/" + issueKey);
        return new JSONObject(this.tester.getDialog().getResponseText());
    }

    private void restoreData(boolean issueLinkingEnabled) throws IOException {
        this.administration.restoreDataWithReplacedTokens("TestIssueResourceIssueLinks.xml", Collections.singletonMap("@@ISSUELINKING@@", issueLinkingEnabled ? "1" : "0"));
    }
}

