/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import java.util.Arrays;

public class TestIssueResourceCustomFields
extends RestFuncTest {
    public void testTextField() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject textField = this.getField("customfield_10021");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textfield", (String)TestIssueResourceCustomFields.typeOf(textField));
        TestIssueResourceCustomFields.assertEquals((String)"this is text", (String)TestIssueResourceCustomFields.stringValue(textField));
    }

    public void testTextArea() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject textArea = this.getField("customfield_10013");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:textarea", (String)TestIssueResourceCustomFields.typeOf(textArea));
        TestIssueResourceCustomFields.assertEquals((String)"lots of text here, brother!", (String)TestIssueResourceCustomFields.stringValue(textArea));
    }

    public void testDatePicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject datePickerCF = this.getField("customfield_10012");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datepicker", (String)TestIssueResourceCustomFields.typeOf(datePickerCF));
        TestIssueResourceCustomFields.assertEquals((String)"2010-06-23", (String)TestIssueResourceCustomFields.stringValue(datePickerCF));
    }

    public void testDateTime() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject dateTimeCF = this.getField("customfield_10001");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:datetime", (String)TestIssueResourceCustomFields.typeOf(dateTimeCF));
        this.assertEqualDateStrings("2010-06-16T15:26:00.000+1000", TestIssueResourceCustomFields.stringValue(dateTimeCF));
    }

    public void testFloat() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject floatCF = this.getField("customfield_10018");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)TestIssueResourceCustomFields.typeOf(floatCF));
        TestIssueResourceCustomFields.assertEquals((Object)42.0, (Object)TestIssueResourceCustomFields.doubleValue(floatCF));
    }

    public void testImportId() throws Exception {
        this.administration.restoreData("TestIssueLinkCheck.xml");
        JSONObject bugzillaId = this.getField("ANOT-1", "customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:importid", (String)TestIssueResourceCustomFields.typeOf(bugzillaId));
        TestIssueResourceCustomFields.assertEquals((Object)2.0, (Object)TestIssueResourceCustomFields.doubleValue(bugzillaId));
    }

    public void testSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject selectList = this.getField("customfield_10020");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:select", (String)TestIssueResourceCustomFields.typeOf(selectList));
        TestIssueResourceCustomFields.assertEquals((String)"Select!", (String)TestIssueResourceCustomFields.stringValue(selectList));
    }

    public void testRadioButtons() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject radioButtons = this.getField("customfield_10019");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", (String)TestIssueResourceCustomFields.typeOf(radioButtons));
        TestIssueResourceCustomFields.assertEquals((String)"Radio Ga Ga", (String)TestIssueResourceCustomFields.stringValue(radioButtons));
    }

    public void testProject() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject projectPicker = this.getField("customfield_10007");
        JSONObject project = projectPicker.getJSONObject("value");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:project", (String)TestIssueResourceCustomFields.typeOf(projectPicker));
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/project/MKY"), (String)project.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"MKY", (String)project.getString("key"));
    }

    public void testMultiVersion() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject multiVersion = this.getField("customfield_10011");
        JSONArray versions = TestIssueResourceCustomFields.arrayValue(multiVersion);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion", (String)TestIssueResourceCustomFields.typeOf(multiVersion));
        TestIssueResourceCustomFields.assertEquals((int)2, (int)versions.length());
        JSONObject v1 = versions.getJSONObject(0);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10000"), (String)v1.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 1", (String)v1.getString("name"));
        JSONObject v5 = versions.getJSONObject(1);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10002"), (String)v5.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 5", (String)v5.getString("name"));
    }

    public void testVersion() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject version = this.getField("customfield_10009");
        JSONObject v4 = version.getJSONObject("value");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:version", (String)TestIssueResourceCustomFields.typeOf(version));
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10001"), (String)v4.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"New Version 4", (String)v4.getString("name"));
    }

    public void testUserPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject userPicker = this.getField("customfield_10022");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:userpicker", (String)TestIssueResourceCustomFields.typeOf(userPicker));
        JSONObject fred = userPicker.getJSONObject("value");
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=fred"), (String)fred.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)fred.getString("name"));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)fred.getString("displayName"));
    }

    public void testUrl() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject url = this.getField("customfield_10010");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:url", (String)TestIssueResourceCustomFields.typeOf(url));
        TestIssueResourceCustomFields.assertEquals((String)"http://www.atlassian.com", (String)TestIssueResourceCustomFields.stringValue(url));
    }

    public void testMultiSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject multiSelect = this.getField("customfield_10017");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiselect", (String)TestIssueResourceCustomFields.typeOf(multiSelect));
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("Option 2", "Option 3"), TestIssueResourceCustomFields.asList(TestIssueResourceCustomFields.arrayValue(multiSelect)));
    }

    public void testMultiCheckboxes() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject multiCheckbox = this.getField("customfield_10016");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", (String)TestIssueResourceCustomFields.typeOf(multiCheckbox));
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("check out my stats"), TestIssueResourceCustomFields.asList(TestIssueResourceCustomFields.arrayValue(multiCheckbox)));
    }

    public void testMultiUserPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject multiUser = this.getField("customfield_10006");
        JSONArray users = TestIssueResourceCustomFields.arrayValue(multiUser);
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", (String)TestIssueResourceCustomFields.typeOf(multiUser));
        TestIssueResourceCustomFields.assertEquals((int)2, (int)users.length());
        JSONObject admin = users.getJSONObject(0);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)admin.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"admin", (String)admin.getString("name"));
        TestIssueResourceCustomFields.assertEquals((String)"Administrator", (String)admin.getString("displayName"));
        JSONObject fred = users.getJSONObject(1);
        TestIssueResourceCustomFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=fred"), (String)fred.getString("self"));
        TestIssueResourceCustomFields.assertEquals((String)"fred", (String)fred.getString("name"));
        TestIssueResourceCustomFields.assertEquals((String)"Fred Normal", (String)fred.getString("displayName"));
    }

    public void testMultiGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject multiGroup = this.getField("customfield_10005");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker", (String)TestIssueResourceCustomFields.typeOf(multiGroup));
        JSONArray groups = TestIssueResourceCustomFields.arrayValue(multiGroup);
        TestIssueResourceCustomFields.assertEquals((Object)"jira-developers", (Object)groups.get(0));
        TestIssueResourceCustomFields.assertEquals((Object)"jira-users", (Object)groups.get(1));
    }

    public void testGroupPicker() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject group = this.getField("customfield_10002");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:grouppicker", (String)TestIssueResourceCustomFields.typeOf(group));
        TestIssueResourceCustomFields.assertEquals((String)"jira-developers", (String)TestIssueResourceCustomFields.stringValue(group));
    }

    public void testCascadingSelect() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject cascadingSelect = this.getField("customfield_10000");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (String)TestIssueResourceCustomFields.typeOf(cascadingSelect));
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("Option 2", "Sub-option I"), TestIssueResourceCustomFields.asList(TestIssueResourceCustomFields.arrayValue(cascadingSelect)));
    }

    public void testLabels() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        JSONObject labels = this.getField("customfield_10004");
        TestIssueResourceCustomFields.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:labels", (String)TestIssueResourceCustomFields.typeOf(labels));
        TestIssueResourceCustomFields.assertEquals(Arrays.asList("wack", "whoa"), TestIssueResourceCustomFields.asList(TestIssueResourceCustomFields.arrayValue(labels)));
    }

    public void testEmptyFieldsReturned() throws Exception {
        this.administration.restoreData("TestIssueResourceCustomFields.xml");
        this.navigation.issue().createIssue("homosapien", "Bug", "some issue");
        JSONObject fields = this.fields("HSP-2");
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10000"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10000"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10012"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10012"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10001"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10001"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10013"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10013"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10002"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10002"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10003"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10003"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10016"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10016"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10017"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10017"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10005"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10005"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10006"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10006"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10018"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10018"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10007"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10007"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10019"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10019"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10008"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10008"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10020"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10020"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10009"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10009"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10021"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10021"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10010"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10010"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10022"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10022"));
        TestIssueResourceCustomFields.assertTrue((boolean)fields.has("customfield_10011"));
        TestIssueResourceCustomFields.assertTrue((boolean)TestIssueResourceCustomFields.isNull(fields, "customfield_10011"));
    }

    protected JSONObject getField(String fieldName) throws JSONException {
        return this.getField("HSP-1", fieldName);
    }

    protected JSONObject getField(String issueKey, String fieldName) throws JSONException {
        return this.fields(issueKey).getJSONObject(fieldName);
    }

    private static String typeOf(JSONObject customField) throws JSONException {
        return customField.getString("type");
    }

    private static String stringValue(JSONObject customField) throws JSONException {
        return customField.getString("value");
    }

    private static double doubleValue(JSONObject floatCF) throws JSONException {
        return floatCF.getDouble("value");
    }

    private static JSONArray arrayValue(JSONObject multiSelect) throws JSONException {
        return multiSelect.getJSONArray("value");
    }

    private JSONObject fields(String issueKey) throws JSONException {
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/" + issueKey, "fields");
        return issue.getJSONObject("fields");
    }

    private static boolean isNull(JSONObject fields, String fieldName) throws JSONException {
        JSONObject field = fields.getJSONObject(fieldName);
        return !field.has("value");
    }
}

