/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

public class TestIssueResourceAttachments
extends RestFuncTest {
    private static final String ISSUE_KEY = "MKY-1";

    public void testAttachmentsExpanded() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/MKY-1");
        JSONObject issue = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceAttachments.assertEquals((String)ISSUE_KEY, (String)issue.getString("key"));
        JSONArray items = issue.getJSONObject("fields").getJSONObject("attachment").getJSONArray("value");
        TestIssueResourceAttachments.assertEquals((int)2, (int)items.length());
        JSONObject attachment1 = items.getJSONObject(0);
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/attachment/10000"), (String)attachment1.getString("self"));
        TestIssueResourceAttachments.assertEquals((String)"attachment.txt", (String)attachment1.getString("filename"));
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)attachment1.getJSONObject("author").getString("self"));
        TestIssueResourceAttachments.assertEquals((String)"admin", (String)attachment1.getJSONObject("author").getString("name"));
        TestIssueResourceAttachments.assertEquals((String)"Administrator", (String)attachment1.getJSONObject("author").getString("displayName"));
        this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.getString("created"));
        TestIssueResourceAttachments.assertEquals((long)19L, (long)attachment1.getLong("size"));
        TestIssueResourceAttachments.assertEquals((String)"text/plain", (String)attachment1.getString("mimeType"));
        TestIssueResourceAttachments.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.getString("content"));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

