/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Collections;

public class TestIssueResource
extends RestFuncTest {
    public void testViewIssueNotFound() throws Exception {
        WebResponse resp123 = this.GET("rest/api/2.0.alpha1/issue/1");
        TestIssueResource.assertEquals((int)404, (int)resp123.getResponseCode());
        this.assertNoLongerExistsError(resp123);
        WebResponse resp123Xml = this.GET("rest/api/2.0.alpha1/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9,*/*;q=0.8"));
        TestIssueResource.assertEquals((int)404, (int)resp123Xml.getResponseCode());
        this.assertNoLongerExistsError(resp123Xml);
        WebResponse resp415 = this.GET("rest/api/2.0.alpha1/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9"));
        TestIssueResource.assertEquals((int)406, (int)resp415.getResponseCode());
    }

    public void testNotLoggedIn_IssueExists() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        this.navigation.logout();
        WebResponse response = this.GET("/rest/api/2.0.alpha1/issue/" + key);
        TestIssueResource.assertEquals((int)401, (int)response.getResponseCode());
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    private void assertNoLongerExistsError(WebResponse resp123) throws JSONException, IOException {
        JSONObject content = new JSONObject(resp123.getText());
        TestIssueResource.assertEquals((int)1, (int)content.getJSONArray("errorMessages").length());
        TestIssueResource.assertEquals((String)"Issue Does Not Exist", (String)content.getJSONArray("errorMessages").getString(0));
    }
}

