/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;

public class TestBulkMoveIssuesForProfessional
extends BulkChangeIssues {
    protected static final String SUB_TASK_NEW_TYPE = "New Sub-task Type";
    protected static final String SUB_TASK_DIFFERENT_TYPE = "Different Sub-task Type";

    public TestBulkMoveIssuesForProfessional(String name) {
        super(name);
    }

    public void testBulkMoveIssuesForProfessional() {
        this.bulkChangeSetup();
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Tests for Professional Version");
        this._testBulkMoveSameSubTasksToSameSubTaskType();
        this._testBulkMoveSameSubTasksToANewSubTaskType();
        this._testBulkMoveDiffSubTasksToOneOfItsSubTaskType();
        this._testBulkMoveDiffSubTasksToAnotherSubTaskType();
        this._testBulkMoveSubTaskAndItsParentSelectParents();
        this._testBulkMoveSubTaskAndItsParentSelectSubTasks();
    }

    public void _testBulkMoveSameSubTasksToSameSubTaskType() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtasks with the SAME subtask type to the SAME sub task type");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String issueKey2 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 2", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey2, "Sub-task", "subtask 2", "");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.selectOption("issuetype", "Sub-task");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertNoChangesForIssue(subTaskKey1);
        this.assertNoChangesForIssue(subTaskKey2);
        this.deactivateSubTasks();
    }

    public void _testBulkMoveSameSubTasksToANewSubTaskType() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtasks with the SAME subtask type to a DIFFERENT subtask type");
        this.createSubTaskType(SUB_TASK_DIFFERENT_TYPE, "This is the different subtask type to move to");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String issueKey2 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 2", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey2, "Sub-task", "subtask 2", "");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.selectOption("issuetype", SUB_TASK_DIFFERENT_TYPE);
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertLastChangeHistoryIs(subTaskKey1, "Type", "Sub-task", SUB_TASK_DIFFERENT_TYPE);
        this.assertLastChangeHistoryIs(subTaskKey2, "Type", "Sub-task", SUB_TASK_DIFFERENT_TYPE);
        this.deactivateSubTasks();
    }

    public void _testBulkMoveDiffSubTasksToOneOfItsSubTaskType() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtasks with DIFFERENT subtask types to ONE OF THE SELECTED subtasks type");
        this.createSubTaskType(SUB_TASK_DIFFERENT_TYPE, "This is the different subtask type");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String issueKey2 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 2", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey2, SUB_TASK_DIFFERENT_TYPE, "subtask 2", "this subtask has a different subtask type");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.selectOption("issuetype", SUB_TASK_DIFFERENT_TYPE);
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertLastChangeHistoryIs(subTaskKey1, "Type", "Sub-task", SUB_TASK_DIFFERENT_TYPE);
        this.assertNoChangesForIssue(subTaskKey2);
        this.deactivateSubTasks();
    }

    public void _testBulkMoveDiffSubTasksToAnotherSubTaskType() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtasks with DIFFERENT subtask types to a DIFFERENT subtask type");
        this.createSubTaskType(SUB_TASK_DIFFERENT_TYPE, "This is the different subtask type assigned to a subtask");
        this.createSubTaskType(SUB_TASK_NEW_TYPE, "This is the different subtask type to move to");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String issueKey2 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 2", "Major", null, null, null, null, "", "", null, null, null);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey2, SUB_TASK_DIFFERENT_TYPE, "subtask 2", "this subtask has a different subtask type");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.selectOption("issuetype", SUB_TASK_NEW_TYPE);
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertLastChangeHistoryIs(subTaskKey1, "Type", "Sub-task", SUB_TASK_NEW_TYPE);
        this.assertLastChangeHistoryIs(subTaskKey2, "Type", "Sub-task", SUB_TASK_NEW_TYPE);
        this.deactivateSubTasks();
    }

    public void _testBulkMoveSubTaskAndItsParentSelectParents() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtask and its parent - Move the parents project");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String issueId1 = this.getIssueIdWithIssueKey(issueKey1);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1 of parent 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 2 of parent 1", "");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "parent 2 with no subtasks", "Major", null, null, null, null, "", "", null, null, null);
        String issueId2 = this.getIssueIdWithIssueKey(issueKey2);
        String issueKey3 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 3 thats excluded from the move", "Major", null, null, null, null, "", "", null, null, null);
        String issueId3 = this.getIssueIdWithIssueKey(issueKey3);
        String subTaskKey3 = this.addSubTaskToIssue(issueKey3, "Sub-task", "subtask 1 of parent 3", "the parent is excluded hence this subtask is also excluded");
        String subTaskId3 = this.getIssueIdWithIssueKey(subTaskKey3);
        String issueKey4 = this.addIssue("homosapien", "HSP", "Bug", "parent 4 with no subtasks and excluded", "Major", null, null, null, null, "", "", null, null, null);
        String issueId4 = this.getIssueIdWithIssueKey(issueKey4);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + issueId1);
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.selectCheckbox("bulkedit_" + issueId2);
        this.assertCheckboxNotSelected("bulkedit_" + issueId3);
        this.assertCheckboxNotSelected("bulkedit_" + subTaskId3);
        this.assertCheckboxNotSelected("bulkedit_" + issueId4);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.assertTextPresent("Select all Parent Issues");
        this.assertTextPresent("Select all Sub-Task Issues");
        this.setFormElement("collection", "parent");
        this.clickOnNext();
        this.assertFormElementPresent("pid");
        this.selectOption("pid", "monkey");
        this.assertTextPresent("Target Issue Type");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertLastChangeHistoryIs(issueKey1, "Project", "neanderthal", "monkey");
        this.assertLastChangeHistoryIs(subTaskKey1, "Project", "neanderthal", "monkey");
        this.assertLastChangeHistoryIs(subTaskKey2, "Project", "neanderthal", "monkey");
        this.assertLastChangeHistoryIs(issueKey2, "Project", "homosapien", "monkey");
        this.assertNoChangesForIssue(issueKey3);
        this.assertNoChangesForIssue(subTaskKey3);
        this.assertNoChangesForIssue(issueKey4);
        this.deactivateSubTasks();
    }

    public void _testBulkMoveSubTaskAndItsParentSelectSubTasks() {
        TestBulkMoveIssuesForProfessional.log("Bulk Move - Test bulk move subtask and its parent - Move Subtasks from default to new subtask type");
        this.createSubTaskType(SUB_TASK_NEW_TYPE, "Move the sub tasks to this type");
        String issueKey1 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String issueId1 = this.getIssueIdWithIssueKey(issueKey1);
        String subTaskKey1 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 1 of parent 1", "");
        String subTaskId1 = this.getIssueIdWithIssueKey(subTaskKey1);
        String subTaskKey2 = this.addSubTaskToIssue(issueKey1, "Sub-task", "subtask 2 of parent 1", "");
        String subTaskId2 = this.getIssueIdWithIssueKey(subTaskKey2);
        String issueKey2 = this.addIssue("neanderthal", "NDT", "Bug", "subtask parent 1", "Major", null, null, null, null, "", "", null, null, null);
        String issueId2 = this.getIssueIdWithIssueKey(issueKey2);
        String subTaskKey3 = this.addSubTaskToIssue(issueKey2, "Sub-task", "subtask 1 of parent 2", "");
        String subTaskId3 = this.getIssueIdWithIssueKey(subTaskKey3);
        String subTaskKey4 = this.addSubTaskToIssue(issueKey2, "Sub-task", "subtask 2 of parent 2", "This subtask is not included in the bulk move and hence its subtask type remains default");
        String subTaskId4 = this.getIssueIdWithIssueKey(subTaskKey4);
        this.activateSubTasks();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.isStepChooseIssues();
        this.selectCheckbox("bulkedit_" + issueId1);
        this.selectCheckbox("bulkedit_" + issueId2);
        this.selectCheckbox("bulkedit_" + subTaskId1);
        this.selectCheckbox("bulkedit_" + subTaskId2);
        this.selectCheckbox("bulkedit_" + subTaskId3);
        this.assertCheckboxNotSelected("bulkedit_" + subTaskId4);
        this.clickOnNext();
        this.chooseOperationBulkMove();
        this.assertTextPresent("Select all Parent Issues");
        this.assertTextPresent("Select all Sub-Task Issues");
        this.setFormElement("collection", "subtask");
        this.clickOnNext();
        this.assertTextNotPresent("Target Project");
        this.selectOption("issuetype", SUB_TASK_NEW_TYPE);
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.clickOnNext();
        this.assertNoChangesForIssue(issueKey1);
        this.assertNoChangesForIssue(issueKey2);
        this.assertLastChangeHistoryIs(subTaskKey1, "Type", "Sub-task", SUB_TASK_NEW_TYPE);
        this.assertLastChangeHistoryIs(subTaskKey2, "Type", "Sub-task", SUB_TASK_NEW_TYPE);
        this.assertLastChangeHistoryIs(subTaskKey3, "Type", "Sub-task", SUB_TASK_NEW_TYPE);
        this.assertNoChangesForIssue(subTaskKey4);
        this.deactivateSubTasks();
    }
}

