/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.webtests.ztests.bulk.BulkChangeIssues;

public class TestBulkMoveIssues
extends BulkChangeIssues {
    protected static final String TARGET_PROJECT = "Target Project";
    protected static final String PROJECT_KEYWORD = "Project";
    protected static final String ERROR_MOVE_PERMISSION = "You do not have the permission to move one or more of the selected issues";
    protected static final String STD_ISSUE_SELECTION = "Select Projects and Issue Types";
    private static final String MONKEY_PID_OPTION = "10000_1_pid";
    protected static final String TARGET_PROJECT_ID = "10000_1_pid";
    protected static final String RANDOM_ISSUE_SUMMARY = "random_50";
    protected static final String CHECKBOX_RETAIN_PREFIX = "retain_";
    public static final String SAME_FOR_ALL = "sameAsBulkEditBean";
    private static final String BULK_EDIT_KEY = "10000_1_";

    public TestBulkMoveIssues(String name) {
        super(name);
    }

    public void testBulkMove() {
        TestBulkMoveIssues.log("Bulk Move - Tests for Standard Version");
        this.restoreData("TestBulkMoveIssues.xml");
        this.grantGlobalPermission(33, "jira-users");
        this._testMoveOperationUnavailableNoMovePermission();
        this._testMoveSTDComponentsAndVersionsRequiredFailure();
        this._testDontRetainRequiredComponentAndVersions();
        this._testDontRetainNotRequiredComponentAndVersions();
        this._testDontRetainNotRequiredNotSelectedComponentAndVersions();
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testBulkMoveWithCaseSensitiveDifferences() throws Exception {
        this.restoreData("TestBulkMoveIssuesWithCaseSensitiveMatches.xml");
        this.grantGlobalPermission(33, "jira-users");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.checkCheckbox(SAME_FOR_ALL, "10002_1_");
        this.tester.selectOption("10002_1_pid", "homosapien");
        this.navigation.clickOnNext();
        this.tester.assertOptionEquals("versions_10006", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10002", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10006", "Unknown");
        this.tester.assertOptionEquals("components_10010", "Unknown");
        this.tester.selectOption("versions_10006", "New Version 5");
        this.tester.selectOption("fixVersions_10002", "New Version 3");
        this.tester.selectOption("fixVersions_10006", "New Version 5");
        this.tester.selectOption("components_10010", "New Component 2");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        this.gotoIssue("MKY-8");
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
    }

    public void testBulkMoveWithCaseSensitiveDifferencesAndRememberPreviousSelection() throws Exception {
        this.restoreData("TestBulkMoveIssuesWithCaseSensitiveMatches.xml");
        this.grantGlobalPermission(33, "jira-users");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.selectOption("10002_1_pid", "homosapien");
        this.tester.selectOption("10002_2_pid", "homosapien");
        this.navigation.clickOnNext();
        this.tester.assertOptionEquals("versions_10006", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10002", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10006", "Unknown");
        this.tester.assertOptionEquals("components_10010", "Unknown");
        this.tester.selectOption("versions_10006", "New Version 5");
        this.tester.selectOption("fixVersions_10002", "New Version 3");
        this.tester.selectOption("fixVersions_10006", "New Version 5");
        this.tester.selectOption("components_10010", "New Component 2");
        this.navigation.clickOnNext();
        this.tester.assertOptionEquals("versions_10006", "New Version 5");
        this.tester.assertOptionEquals("fixVersions_10006", "New Version 5");
        this.tester.assertOptionEquals("components_10010", "New Component 2");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        this.gotoIssue("MKY-8");
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
    }

    public void testBulkMoveRememberPreviousSelection() throws Exception {
        this.restoreData("TestBulkMoveMappingAssignee.xml");
        this.grantGlobalPermission(33, "jira-users");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        String hsp2 = this.navigation.issue().createIssue("homosapien", "Task", "second issue");
        String hsp3 = this.navigation.issue().createIssue("homosapien", "Task", "another issue");
        this.navigation.issue().setComponents(hsp1, "New Component 3");
        this.navigation.issue().setComponents(hsp2, "New Component 1");
        this.navigation.issue().setComponents(hsp3, "New Component 2");
        this.navigation.issue().setFixVersions(hsp1, "New Version 3");
        this.navigation.issue().setFixVersions(hsp2, "New Version 5");
        this.navigation.issue().setFixVersions(hsp3, "New Version 3");
        this.navigation.issue().setAffectsVersions(hsp1, "New Version 2");
        this.navigation.issue().setAffectsVersions(hsp2, "New Version 1");
        this.navigation.issue().createIssue("monkey", "Bug", "third issue");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.selectOption("10000_1_pid", "monkey");
        this.tester.selectOption("10002_1_pid", "monkey");
        this.tester.selectOption("10000_3_pid", "monkey");
        this.navigation.clickOnNext();
        this.tester.assertOptionEquals("versions_10001", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10003", "New Version 3");
        this.tester.assertOptionEquals("components_10002", "New Component 3");
        this.tester.selectOption("versions_10001", "New Version 6");
        this.tester.selectOption("fixVersions_10003", "New Version 5");
        this.tester.selectOption("components_10002", "New Component 4");
        this.navigation.clickOnNext();
        this.tester.assertOptionEquals("versions_10000", "Unknown");
        this.tester.assertOptionEquals("fixVersions_10003", "New Version 5");
        this.tester.assertOptionEquals("fixVersions_10005", "New Version 5");
        this.tester.assertOptionEquals("components_10000", "Unknown");
        this.tester.assertOptionEquals("components_10001", "Unknown");
        this.tester.selectOption("versions_10000", "New Version 3");
        this.tester.selectOption("components_10000", "New Component 3");
        this.tester.selectOption("components_10001", "New Component 4");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
    }

    public void testBulkMoveWithAssigneeRetain() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingAssignee.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().assignIssue(hsp1, "", "fred");
        this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.tester.selectOption("10000_1_pid", "monkey");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.tester.selectOption("assignee", "jon");
        this.tester.checkCheckbox("retain_assignee");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        this.navigation.issue().viewIssue("MKY-1");
        this.assertions.getViewIssueAssertions().assertAsignee("Administrator");
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "MKY");
        this.navigation.issue().viewIssue(firstIssueKey);
        this.assertions.getViewIssueAssertions().assertAsignee("jon");
    }

    public void testBulkMoveWithAssigneeDontRetain() throws Exception {
        this.administration.restoreData("TestBulkMoveMappingAssignee.xml");
        String hsp1 = this.navigation.issue().createIssue("homosapien", "Bug", "first issue");
        this.navigation.issue().assignIssue(hsp1, "", "fred");
        this.navigation.issue().createIssue("monkey", "Bug", "second issue");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.isStepSelectProjectIssueType();
        this.tester.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.tester.selectOption("10000_1_pid", "monkey");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.tester.selectOption("assignee", "jon");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        this.navigation.issue().viewIssue("MKY-1");
        this.assertions.getViewIssueAssertions().assertAsignee("jon");
        String firstIssueKey = this.getIssueKeyWithSummary("first issue", "MKY");
        this.navigation.issue().viewIssue(firstIssueKey);
        this.assertions.getViewIssueAssertions().assertAsignee("jon");
    }

    private void _testMoveOperationUnavailableNoMovePermission() {
        TestBulkMoveIssues.log("Bulk Move - move operation is not available without the move permission");
        this.removeGroupPermission("Default Permission Scheme", 25, "jira-developers");
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.assertTextPresent(ERROR_MOVE_PERMISSION);
        this.grantGroupPermission("Default Permission Scheme", 25, "jira-developers");
    }

    private void _testMoveSTDComponentsAndVersionsRequiredFailure() {
        TestBulkMoveIssues.log("Bulk Move - STD - components and versions required - failure");
        this.setRequiredFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "neanderthal");
        this.navigation.clickOnNext();
        this.navigation.clickOnNext();
        this.assertErrorMsgFieldRequired("Component/s", "neanderthal", "components");
        this.assertErrorMsgFieldRequired("Fix Version/s", "neanderthal", "versions");
        this.assertErrorMsgFieldRequired("Affects Version/s", "neanderthal", "versions");
        this.resetFields();
    }

    private void _testDontRetainRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Retain, components and versions Required, Select new values");
        this.resetFields();
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, null, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 5"}, null, "", "", null, null, null);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"issueKey2", (Object)"priority", (Object)"Major"), null, issueKey2);
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"summary", (Object)"issueKey3", (Object)"priority", (Object)"Major", (Object)"version", (Object)"New Version 4"), null, issueKey3);
        this.setRequiredFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "homosapien");
        this.navigation.clickOnNext();
        this.assertTextPresent("Update Fields for Target Project");
        this.selectOption("components_-1", "New Component 1");
        this.selectOption("fixVersions_-1", "New Version 1");
        this.selectOption("versions_-1", "New Version 2");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "HSP");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("homosapien");
        this.assertLinkNotPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponents("New Component 1");
        this.assertions.getViewIssueAssertions().assertFixVersions("New Version 1");
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 2");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey1, (Object)"component", (Object)"New Component 1", (Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), null, issueKey1);
        this.gotoIssue(issueKey2);
        this.assertions.getViewIssueAssertions().assertComponents("New Component 2");
        this.assertions.getViewIssueAssertions().assertFixVersions("New Version 1");
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 2");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey2, (Object)"component", (Object)"New Component 2", (Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), null, issueKey2);
        this.gotoIssue(issueKey3);
        this.assertions.getViewIssueAssertions().assertComponents("New Component 3");
        this.assertions.getViewIssueAssertions().assertFixVersions("New Version 5");
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 4");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"key", (Object)issueKey3, (Object)"component", (Object)"New Component 3", (Object)"fixVersion", (Object)"New Version 5", (Object)"version", (Object)"New Version 4"), null, issueKey3);
        this.resetFields();
    }

    private void _testDontRetainNotRequiredComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Dont Retain, components and versions Not Required, Select new values");
        this.addIssue("monkey", "MKY", "Bug", "Too much fear creeping in", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "None");
        this.selectOption("fixVersions_10000", "New Version 5");
        this.selectOption("versions_10004", "New Version 5");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("Too much fear creeping in", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersionsNone();
        this.assertions.getViewIssueAssertions().assertFixVersions("New Version 3");
        this.gotoIssue(issueKey2);
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersionsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.gotoIssue(issueKey3);
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 5");
        this.assertions.getViewIssueAssertions().assertFixVersions("New Version 3");
        this.resetFields();
    }

    private void _testDontRetainNotRequiredNotSelectedComponentAndVersions() {
        TestBulkMoveIssues.log("Bulk Move - STD - Dont Retain, components and versions Not Required, Dont Select new values");
        this.addIssue("monkey", "MKY", "Bug", "issueKey1", "Major", null, null, new String[]{"New Version 3"}, null, "", "", null, null, null);
        String issueKey2 = this.addIssue("homosapien", "HSP", "Bug", "issueKey2", "Major", new String[]{"New Component 2"}, null, null, null, "", "", null, null, null);
        String issueKey3 = this.addIssue("homosapien", "HSP", "Bug", "issueKey3", "Major", new String[]{"New Component 3"}, new String[]{"New Version 4"}, new String[]{"New Version 3"}, null, "", "", null, null, null);
        this.resetFields();
        this.displayAllIssues();
        this.bulkChangeIncludeAllPages();
        this.bulkChangeChooseIssuesAll();
        this.chooseOperationBulkMove();
        this.assertTextPresent(STD_ISSUE_SELECTION);
        this.checkCheckbox(SAME_FOR_ALL, BULK_EDIT_KEY);
        this.selectOption("10000_1_pid", "monkey");
        this.navigation.clickOnNext();
        this.isStepSetFields();
        this.assertTextPresentBeforeText("components", "None");
        this.navigation.clickOnNext();
        this.isStepConfirmation();
        this.navigation.clickOnNext();
        String issueKey1 = this.getIssueKeyWithSummary("issueKey1", "MKY");
        this.gotoIssue(issueKey1);
        this.assertLinkPresentWithText("monkey");
        this.assertLinkNotPresentWithText("homosapien");
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersionsNone();
        this.gotoIssue(issueKey2);
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersionsNone();
        this.gotoIssue(issueKey3);
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.assertions.getViewIssueAssertions().assertAffectsVersionsNone();
        this.resetFields();
    }

    private void isStepSelectProjectIssueType() {
        this.tester.assertTextPresent(STD_ISSUE_SELECTION);
    }

    private void isStepSetFields() {
        this.assertTextPresent("Update Fields for Target Project");
        TestBulkMoveIssues.log("Step Set Fields");
    }
}

