/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestAttachFile
extends JIRAWebTest {
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";

    public TestAttachFile(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestFullAnonymousPermissions.xml");
        this.administration.attachments().enable();
    }

    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public void testAttachFileLoggedIn() {
        this.disallowAnonymousAttachmentCreation();
        this.gotoIssue("MKY-2");
        this.clickLink("attach-file");
        this.assertElementPresent("attach-file-submit");
    }

    public void testAttachNoFileError() {
        this.gotoIssue("MKY-2");
        this.clickLink("attach-file");
        this.assertTextNotPresent("Errors");
        this.assertTextNotPresent("Please indicate the file you wish to upload");
        this.setWorkingForm("attach-file");
        this.submit();
        this.assertTextPresent("Please indicate the file you wish to upload");
    }

    public void testAttachFileLoggedOutNoAnonymousPermission() {
        this.disallowAnonymousAttachmentCreation();
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.gotoIssue("MKY-2");
        this.assertLinkNotPresent("attach-file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertTextPresent("You do not have permission to create attachments for this issue.");
        this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertLinkWithTextExists(LOGIN);
        this.assertLinkWithTextExists(SIGNUP);
        this.assertElementNotPresent("attach-file-submit");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.assertElementNotPresent("attach-file-submit");
    }

    public void testAttachFileLoggedOutWithAnonymousPermission() {
        this.logout();
        this.clickLinkWithText("Log in again.");
        this.gotoIssue("MKY-2");
        this.clickLink("attach-file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertElementPresent("attach-file-submit");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertElementNotPresent("attach-file-submit");
    }

    public void testAttachFileLoggedInWithoutPermission() {
        this.disallowAnyoneAttachmentCreation();
        this.gotoIssue("MKY-2");
        this.assertLinkNotPresent("attach-file");
        this.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.assertTextPresent("You do not have permission to create attachments for this issue.");
        this.assertElementNotPresent("attach-file-submit");
        this.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.assertTextNotPresent("You do not have permission to create attachments for this issue.");
        this.assertTextNotPresent("You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.assertElementNotPresent("attach-file-submit");
    }

    private void disallowAnonymousAttachmentCreation() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_19_");
        this.submit("Delete");
        this.gotoDashboard();
    }

    private void disallowAnyoneAttachmentCreation() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_19_");
        this.submit("Delete");
        this.clickLink("del_perm_19_jira-users");
        this.submit("Delete");
        this.gotoDashboard();
    }
}

