/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;

public class TestXsrfVersions
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testArchiveAndUnarchiveVersionsNoPermission() {
        this.administration.restoreData("testReleaseUnreleaseVersions.xml");
        this.administration.project().viewProject("homosapien");
        this.tester.clickLink("manage_versions");
        this.tester.assertTextPresent("version 1");
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditVersionArchives!archive.jspa?versionId=10004&pid=10000");
        this.tester.assertTextPresent("SecurityTokenMissing");
    }

    public void testAddVersionSecurityBreach() {
        this.administration.restoreBlankInstance();
        this.navigation.logout();
        this.tester.gotoPage("AddVersion.jspa?pid=10000");
        this.tester.assertTextNotPresent("On this page you can manage the versions for the");
        this.tester.assertTextNotPresent("New Version 5");
        this.tester.assertTextNotPresent("You must specify a valid version name");
        this.tester.assertTextPresent("SecurityTokenMissing");
    }

    public void testVersionAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("DeleteVersion", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.clickLink("del_New Version 5");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("AddVersion", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.setFormElement("name", "New Version 5");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditVersionDetails", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.clickLink("edit_New Version 5");
                TestXsrfVersions.this.tester.setFormElement("description", "This is New Version 5!");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("VersionDown", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("movedown_10001")), new XsrfCheck("VersionLast", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("movelast_10000")), new XsrfCheck("VersionFirst", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("movefirst_10000")), new XsrfCheck("VersionUp", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("moveup_10001")), new XsrfCheck("MergeVersions", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.clickLink("merge_New Version 1");
                TestXsrfVersions.this.tester.submit("Merge");
            }
        }, new XsrfCheck.FormSubmission("Merge")), new XsrfCheck("ReleaseVersion", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.clickLink("release_New Version 4");
            }
        }, new XsrfCheck.FormSubmission("Release")), new XsrfCheck("UnreleaseVersion", new VersionSetup(){

            public void setup() {
                super.setup();
                TestXsrfVersions.this.tester.clickLink("unrelease_New Version 4");
            }
        }, new XsrfCheck.FormSubmission("Unrelease")), new XsrfCheck("ArchiveVersion", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("archive_New Version 4")), new XsrfCheck("UnarchiveVersion", new VersionSetup(), new XsrfCheck.LinkWithIdSubmission("unarchive_New Version 4"))).run(this.funcTestHelperFactory);
    }

    class VersionSetup
    implements XsrfCheck.Setup {
        VersionSetup() {
        }

        public void setup() {
            TestXsrfVersions.this.navigation.gotoDashboard();
            TestXsrfVersions.this.administration.project().viewProject("homosapien");
            TestXsrfVersions.this.tester.clickLink("manage_versions");
        }
    }
}

