/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestIssueTypeSchemeMigration
extends JIRAWebTest {
    public TestIssueTypeSchemeMigration(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReturnUrl() {
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            TextAssertionsImpl text = new TextAssertionsImpl();
            this.restoreData("TestIssueTypeSchemeMigration.xml");
            this.goToProject("homosapien");
            this.clickLink("selectIssueTypeScheme");
            this.tester.checkCheckbox("createType", "chooseScheme");
            this.selectOption("schemeId", "Issue Type Scheme to Move to");
            this.tester.submit(" OK ");
            XPathLocator locator = new XPathLocator(this.tester, "//*[@id=\"cancelButton\"]");
            text.assertRegexMatch(locator.getHTML(), "location.href=[ ]*'" + this.getEnvironmentData().getContext());
            this.pressCancel();
            this.tester.assertTitleEquals("Project: homosapien - jWebTest JIRA installation ");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
    }

    private void pressCancel() {
        TestIssueTypeSchemeMigration.assertTrue((String)"Scripting must be enabled in the HttpUnit for cancel to work correctly", (boolean)HttpUnitOptions.isScriptingEnabled());
        this.tester.setWorkingForm("jiraform");
        this.tester.clickButton("cancelButton");
    }

    public void testI18n() {
        FuncTestHelperFactory funcTestHelperFactory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        TextAssertions text = funcTestHelperFactory.getTextAssertions();
        Administration admin = funcTestHelperFactory.getAdministration();
        Navigation navigation = funcTestHelperFactory.getNavigation();
        admin.restoreI18nData("TestIssueTypeSchemeMigrationGerman.xml");
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        TestIssueTypeSchemeMigration.log("Setting baseurl to '" + baseUrl + "'");
        navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Konfiguration bearbeiten");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Aktualisieren");
        this.goToProject("monkey");
        this.tester.clickLink("selectIssueTypeScheme");
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "monkey");
        this.tester.submit(" OK ");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(2);
        this.tester.submit("previousBtn");
        this.assertCurrentStep(1);
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(4);
        XPathLocator finishLocator = new XPathLocator(this.tester, "//*[@id=\"nextButton\" and @value=\"Fertigstellen\"]");
        TestIssueTypeSchemeMigration.assertNotNull((Object)finishLocator.getNode());
        this.tester.submit("nextBtn");
        XPathLocator locator = new XPathLocator(this.tester, "//*[@class=\"jiraformbody\"]");
        text.assertRegexMatch(locator, "Vorgangstypschema:[ \\t]+monkey");
    }

    private void assertCurrentStep(int step) {
        TextAssertionsImpl text = new TextAssertionsImpl();
        XPathLocator locator = new XPathLocator(this.tester, "//*[@id=\"currentStep\" and @value=" + step + " ]");
        TestIssueTypeSchemeMigration.assertNotNull((Object)locator.getNode());
    }

    public void testIssueTypeOptionsCorrectForIssueTypeMapping() {
        this.restoreData("TestIssueTypeSchemeMigration.xml");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.submit(" OK ");
        this.assertTextPresent("Issue Type Migration");
        this.assertTextPresent("New Feature");
        this.assertTextPresent("Sub-task ORIG");
        this.submit("nextBtn");
        this.assertTextPresent("Sub-task ORIG");
        this.selectOption("issuetype", "Another Subtask");
        this.selectOption("issuetype", "Sub-task DIFFERENT");
        this.assertOptionNotPresent("issuetype", "Improvement");
        this.assertOptionNotPresent("issuetype", "Bug");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.assertTextPresent("New Feature");
        this.selectOption("issuetype", "Improvement");
        this.selectOption("issuetype", "Bug");
        this.assertOptionNotPresent("issuetype", "Another Subtask");
        this.assertOptionNotPresent("issuetype", "Sub-task DIFFERENT");
    }

    public void testIssueTypeSchemeMigrationNoSubtasksMultiProjects() throws SAXException {
        this.restoreData("TestIssueTypeSchemeMigrationNoSubtasks.xml");
        this.displayAllIssues();
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTableCellHasImage(issueTable, 1, 0, "issue_subtask.gif");
        this.assertTableCellHasImage(issueTable, 2, 0, "newfeature.gif");
        this.assertTableCellHasImage(issueTable, 3, 0, "genericissue.gif");
        this.assertTableCellHasImage(issueTable, 4, 0, "bug.gif");
        this.gotoIssue("HSP-4");
        this.assertTextPresentAfterText("Another Subtask", "Type:");
        this.gotoIssue("HSP-3");
        this.assertTextPresentAfterText("New Feature", "Type:");
        this.gotoIssue("HSP-2");
        this.assertTextPresentAfterText("Sub-task ORIG", "Type:");
        this.gotoIssue("HSP-1");
        this.assertTextPresentAfterText("Bug", "Type:");
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLinkWithText("Issue Types Scheme");
        this.clickLink("associate_10030");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10001");
        this.submit("Associate");
        this.assertTextPresent("There are 2 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLinkWithText("Issue Types Scheme");
        this.clickLink("associate_10020");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10001");
        this.submit("Associate");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Overview (Step 1 of 6)", "homosapien", "New Feature", "1", "homosapien", "Sub-task ORIG", "1"});
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 2 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien"});
        this.selectOption("issuetype", "Sub-task DIFFERENT");
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 3 of 6)", "Update fields for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien."});
        this.assertTextPresent("All field values will be retained.");
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "New Feature", " in project ", "homosapien"});
        this.selectOption("issuetype", "Bug");
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 5 of 6)", "Update fields for issues with current issue type ", "New Feature", " in project ", "homosapien."});
        this.assertTextPresent("All field values will be retained.");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.displayAllIssues();
        issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        this.assertTableCellHasImage(issueTable, 1, 0, "issue_subtask.gif");
        this.assertTableCellHasImage(issueTable, 2, 0, "bug.gif");
        this.assertTableCellHasImage(issueTable, 3, 0, "genericissue.gif");
        this.assertTableCellHasImage(issueTable, 4, 0, "bug.gif");
        this.gotoIssue("HSP-4");
        this.assertTextPresentAfterText("Another Subtask", "Type:");
        this.gotoIssue("HSP-3");
        this.assertTextPresentAfterText("Bug", "Type:");
        this.gotoIssue("HSP-2");
        this.assertTextPresentAfterText("Sub-task DIFFERENT", "Type:");
        this.gotoIssue("HSP-1");
        this.assertTextPresentAfterText("Bug", "Type:");
    }

    public void testIssueTypeSchemeMigrationMultiProjectsSecurityLevels() {
        this.restoreData("TestIssueTypeSchemeMigrationSecurityLevel.xml");
        this.assertPrecondition();
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLinkWithText("Issue Types Scheme");
        this.clickLink("associate_10060");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10020");
        this.selectMultiOptionByValue("projects", "10021");
        this.selectMultiOptionByValue("projects", "10022");
        this.submit("Associate");
        this.assertTextPresent("There are 5 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.assertPrecondition();
        this.gotoAdmin();
        this.clickLink("issue_types");
        this.clickLinkWithText("Issue Types Scheme");
        this.clickLink("associate_10061");
        this.selectMultiOptionByValue("projects", "10000");
        this.selectMultiOptionByValue("projects", "10020");
        this.selectMultiOptionByValue("projects", "10021");
        this.selectMultiOptionByValue("projects", "10022");
        this.submit("Associate");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Overview (Step 1 of 6)", "Bovine", "Sub-task", "3", "Rattus", "Sub-task", "2"});
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Select a new issue type for issues with current issue type ", "Sub-task", "in project ", "Bovine"});
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 3 of 6)", "All field values will be retained."});
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task", "in project", "Rattus"});
        this.submit("nextBtn");
        this.assertCollapsedTextSequence(new String[]{"Issue Type Migration: Update Fields (Step 5 of 6)", "All field values will be retained."});
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.assertPrecondition();
        this.gotoIssue("RAT-7");
        this.assertTextPresentAfterText("Level Mouse", "Security");
        this.assertTextPresentAfterText("DIFFERENT SUBTASK", "Type");
        this.gotoIssue("COW-36");
        this.assertTextPresentAfterText("MyFriendsOnly", "Security");
        this.assertTextPresentAfterText("DIFFERENT SUBTASK", "Type");
    }

    public void testIssueTypeMigrationWithNumericCustomField() {
        this.restoreData("TestIssueTypeMigrationWithNumericCustomField.xml");
        this.gotoAdmin();
        this.tester.clickLink("issue_types");
        this.tester.clickLinkWithText("Issue Types Scheme");
        this.tester.clickLink("associate_10001");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("customfield_10000", "LOREM_IPSUM");
        this.tester.submit("nextBtn");
        this.assertTextPresent("&#39;LOREM_IPSUM&#39; is an invalid number");
        this.assertTextPresent("Issue Type Migration: Update Fields (Step 3 of 4)");
        this.tester.setFormElement("customfield_10000", "857");
        this.tester.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration: Confirmation (Step 4 of 4)");
        this.assertTextPresent("857");
    }

    public void testIssueTypeSchemeMigrationWithSubtasks() throws SAXException {
        this.restoreData("TestIssueTypeSchemeMigrationWithSubtasks.xml");
        this.goToProject("homosapien");
        this.clickLink("selectIssueTypeScheme");
        this.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.submit(" OK ");
        this.assertTextPresent("Issue Type Migration");
        WebTable summaryTable = this.getDialog().getResponse().getTableWithID("summary_table");
        TestIssueTypeSchemeMigration.assertTrue((boolean)this.tableCellHasText(summaryTable, 1, 1, "Bug"));
        TestIssueTypeSchemeMigration.assertTrue((boolean)this.tableCellHasText(summaryTable, 2, 1, "Sub-task ORIG"));
        this.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration");
        this.selectOption("issuetype", "New Feature");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.assertTextPresent("Issue Type Migration");
        this.selectOption("issuetype", "Sub-task DIFFERENT");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.submit("nextBtn");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("New Feature");
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Sub-task DIFFERENT");
    }

    private void assertPrecondition() {
        this.displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 2, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 4, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 4, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 4, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 4, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 5, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 5, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 5, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 5, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 6, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
    }
}

