/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.index;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestReindexMessages
extends FuncTestCase {
    public void testEditProjectFieldConfigScheme() throws Exception {
        this.administration.restoreData("TestEditProjectFieldConfigScheme.xml");
        this.changeFieldConfigSchemeAndAssertMessage(null, "None", false);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Same as default scheme", false);
        this.changeFieldConfigSchemeAndAssertMessage("Same as default scheme", "Different scheme 2", true);
        this.changeFieldConfigSchemeAndAssertMessage("Different scheme 2", "Different scheme 1", true);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Exhaustive 1", false);
        this.changeFieldConfigSchemeAndAssertMessage("Exhaustive 1", "Exhaustive 2 (same as default)", true);
        this.changeFieldConfigSchemeAndAssertMessage(null, "Exhaustive 2 copy with different default", false);
        this.changeFieldConfigSchemeAndAssertMessage(null, "None", false);
    }

    public void testVoting() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().disableVoting();
        this.assertNoVotingMessage();
        this.administration.generalConfiguration().enableVoting();
        this.assertVotingMessage();
        this.administration.reIndex();
        this.administration.generalConfiguration().disableVoting();
        this.assertNoVotingMessage();
    }

    public void testTimeTracking() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertTimeTrackingMessage();
        this.administration.reIndex();
        this.administration.timeTracking().disable();
        this.assertNoTimeTrackingMessage();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertTimeTrackingMessage();
    }

    public void testAddCustomField() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.project().addProject("third project", "third", "admin");
        this._testAddCustomFieldGlobalContext();
        this._testAddCustomFieldSpecificContext(new String[0], new String[]{"4"}, "monkey", "Improvement");
        this._testAddCustomFieldSpecificContext(new String[0], new String[]{"4", "1"}, "monkey", "Improvement");
        this._testAddCustomFieldSpecificContext(new String[]{"10000"}, new String[0], "homosapien", "Bug");
        this._testAddCustomFieldSpecificContext(new String[]{"10000", "10001"}, new String[0], "homosapien", "Bug");
        this._testAddCustomFieldSpecificContext(new String[]{"10000"}, new String[]{"4"}, "homosapien", "Improvement");
        this._testAddCustomFieldSpecificContext(new String[]{"10000", "10001"}, new String[]{"4", "1"}, "homosapien", "Improvement");
    }

    public void testIssueCountOverridesSecurity() throws Exception {
        this.administration.restoreData("TestReindexMessagesIssueCountOverridesSecurity.xml");
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.assertNoCustomFieldMessage();
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
        this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.assertCustomFieldMessage();
    }

    public void testRemoveCustomFieldOption() throws Exception {
        this.administration.restoreBlankInstance();
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:select", "selectCF");
        String numericCustomFieldId = customFieldId.split("_")[1];
        String[] options = new String[]{"bob", "joe", "jill"};
        this.administration.customFields().addOptions(numericCustomFieldId, options);
        this.administration.reIndex();
        for (String option : options) {
            this.administration.customFields().removeOptions(numericCustomFieldId, option);
            this.assertCustomFieldMessage();
            this.administration.reIndex();
            this.assertNoCustomFieldMessage();
        }
    }

    public void testEditCustomFieldSearcher() throws Exception {
        this.administration.restoreBlankInstance();
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", new String[0], new String[0]);
        String numericCustomFieldId = customFieldId.split("_")[1];
        this.administration.customFields().setCustomFieldSearcher(numericCustomFieldId, "com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher");
        this.assertCustomFieldMessage();
        this.administration.reIndex();
        this.administration.customFields().setCustomFieldSearcher(numericCustomFieldId, null);
        this.assertNoCustomFieldMessage();
        this.administration.reIndex();
        this.administration.customFields().setCustomFieldSearcher(numericCustomFieldId, "com.atlassian.jira.plugin.system.customfieldtypes:userpickersearcher");
        this.assertCustomFieldMessage();
        this.administration.reIndex();
        this.administration.customFields().setCustomFieldSearcher(numericCustomFieldId, "com.atlassian.jira.plugin.system.customfieldtypes:userpickersearcher");
        this.assertNoCustomFieldMessage();
    }

    public void testAddCustomFieldConfigurationContext() throws Exception {
        this.administration.restoreBlankInstance();
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        String numericCustomFieldId = customFieldId.split("_")[1];
        this.administration.reIndex();
        String issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "bla", new String[0], new String[]{"10000"});
        this.assertNoCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", new String[0], new String[]{"10001"});
        numericCustomFieldId = customFieldId.split("_")[1];
        issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        String schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "bla", new String[0], new String[]{"10000"});
        this.assertNoCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        this.administration.reIndex();
        issue1 = this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "bla", new String[0], new String[]{"10000"});
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        this.administration.reIndex();
        issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "bla", new String[0], new String[0]);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        this.administration.reIndex();
    }

    public void testEditCustomFieldConfigurationContext() throws Exception {
        this.administration.restoreBlankInstance();
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        String numericCustomFieldId = customFieldId.split("_")[1];
        String bugContextId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Bug Context", new String[]{"1"}, new String[]{"10001"});
        String issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.reIndex();
        this.administration.customFields().editConfigurationSchemeContextById(numericCustomFieldId, bugContextId, "Improvement Context", new String[]{"4"}, new String[]{"10001"});
        this.assertNoCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, bugContextId);
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        String globalContextId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global guy", new String[0], new String[0]);
        this.administration.reIndex();
        this.administration.customFields().editConfigurationSchemeContextById(numericCustomFieldId, globalContextId, "Bug guy", new String[]{"1"}, new String[0]);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, globalContextId);
        globalContextId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global guy", new String[0], new String[0]);
        this.administration.reIndex();
        issue1 = this.navigation.issue().createIssue("monkey", "Improvement", "Test");
        this.administration.customFields().editConfigurationSchemeContextById(numericCustomFieldId, globalContextId, "Bug guy", new String[]{"1"}, new String[0]);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, globalContextId);
        globalContextId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Bug guy", new String[]{"1"}, new String[0]);
        this.administration.reIndex();
        issue1 = this.navigation.issue().createIssue("monkey", "Improvement", "Test");
        this.administration.customFields().editConfigurationSchemeContextById(numericCustomFieldId, globalContextId, "Global guy", new String[0], new String[0]);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", new String[]{"1"}, new String[0]);
        numericCustomFieldId = customFieldId.split("_")[1];
        this.administration.reIndex();
        this.administration.customFields().editConfigurationSchemeContextByLabel(numericCustomFieldId, "Default Configuration Scheme for UserCF", null, new String[]{"4"}, new String[0]);
        this.assertNoCustomFieldMessage();
        issue1 = this.navigation.issue().createIssue("monkey", "Improvement", "Test");
        this.administration.customFields().editConfigurationSchemeContextByLabel(numericCustomFieldId, "Default Configuration Scheme for UserCF", null, new String[]{"1"}, new String[0]);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.reIndex();
        this.navigation.issue().createIssue("monkey", "Improvement", "Test");
        this.administration.customFields().editConfigurationSchemeContextByLabel(numericCustomFieldId, "Default Configuration Scheme for UserCF", null, new String[]{"4"}, new String[0]);
        this.assertCustomFieldMessage();
    }

    public void testRemoveCustomFieldConfigurationContext() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.project().addProject("third project", "third", "admin");
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", new String[]{"1"}, new String[]{"10001"});
        String numericCustomFieldId = customFieldId.split("_")[1];
        String schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        String issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.reIndex();
        this.administration.customFields().removeConfigurationSchemeContextByLabel(numericCustomFieldId, "Default Configuration Scheme for UserCF");
        this.assertNoCustomFieldMessage();
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Default Configuration Scheme for UserCF", new String[]{"1"}, new String[]{"10001"});
        this.administration.reIndex();
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        schemeId = this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Default Configuration Scheme for UserCF", new String[]{"1"}, new String[]{"10001"});
        this.administration.reIndex();
        this.administration.customFields().removeConfigurationSchemeContextById(numericCustomFieldId, schemeId);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        numericCustomFieldId = customFieldId.split("_")[1];
        this.administration.reIndex();
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        issue1 = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.reIndex();
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "BugMonkey Context", new String[]{"1"}, new String[]{"10001"});
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "ImprovementHomosapien Context", new String[]{"4"}, new String[]{"10000"});
        this.administration.reIndex();
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        this.administration.reIndex();
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        this.administration.reIndex();
        this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertNoCustomFieldMessage();
        this.administration.customFields().addConfigurationSchemeContext(numericCustomFieldId, "Global Context", new String[0], new String[0]);
        this.administration.reIndex();
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.administration.customFields().removeGlobalContext(numericCustomFieldId);
        this.assertCustomFieldMessage();
    }

    public void testShowHideFieldsInFieldConfiguration() throws Exception {
        this.administration.restoreData("TestShowHideFieldsInFieldConfiguration.xml");
        this._testShowHideFieldInFieldConfigurationNoEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 2");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this._testShowHideFieldInFieldConfigurationNoEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
        this.administration.project().associateFieldConfigurationScheme("homosapien", null);
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
        this.administration.project().associateFieldConfigurationScheme("homosapien", "Scheme X");
        this.administration.project().associateFieldConfigurationScheme("monkey", "Scheme X");
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 2");
        this.administration.project().associateFieldConfigurationScheme("homosapien", "Scheme Y");
        this.administration.project().associateFieldConfigurationScheme("monkey", "Scheme Y");
        this.administration.reIndex();
        this._testShowHideFieldInFieldConfigurationHasEffect("Default Field Configuration");
        this._testShowHideFieldInFieldConfigurationNoEffect("Field Config 1");
        this._testShowHideFieldInFieldConfigurationHasEffect("Field Config 2");
    }

    public void testAddFieldConfigurationAssociationToScheme() throws Exception {
        this.administration.restoreData("TestAddFieldConfigurationAssociationToScheme.xml");
        this.administration.project().addProject("third project", "third", "admin");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").addAssociation("1", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.administration.reIndex();
        this.navigation.issue().createIssue("third project", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("4", "Field Config 2");
        this.assertFieldConfigurationMessage();
    }

    public void testEditFieldConfigurationAssociationInScheme() throws Exception {
        this.administration.restoreData("TestEditFieldConfigurationAssociationToScheme.xml");
        this.administration.project().addProject("third project", "third", "admin");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").editAssociation("1", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("1", "Field Config 2");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("3", "Field Config 1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.administration.reIndex();
        this.navigation.issue().createIssue("third project", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation(null, "Copy of Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 1");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("3", "Field Config 2");
        this.assertNoFieldConfigurationMessage();
        this.navigation.issue().createIssue("homosapien", "Improvement", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("4", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("4", "Default Field Configuration");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").editAssociation("4", "Copy of Default Field Configuration");
        this.assertNoFieldConfigurationMessage();
    }

    public void testRemoveFieldConfigurationAssociationFromScheme() throws Exception {
        this.administration.restoreData("TestEditFieldConfigurationAssociationToScheme.xml");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 2").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 1");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("3", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("3");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Copy of Default Field Configuration");
        this.administration.reIndex();
        this.navigation.issue().createIssue("homosapien", "Bug", "Test");
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").addAssociation("1", "Field Config 2");
        this.administration.reIndex();
        this.administration.fieldConfigurationSchemes().fieldConfigurationScheme("Scheme 1").removeAssociation("1");
        this.assertFieldConfigurationMessage();
    }

    public void testEnableDisablePlugins() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.disablePluginModule("Issue Operations Plugin", "System Issue Operations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.assertNoPluginsMessage();
        this.administration.disablePluginModule("Custom Field Types & Searchers", "JIRA's system custom field types", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.assertNoPluginsMessage();
        this.administration.disablePluginModule("Custom Field Types & Searchers", "JIRA's system custom field types", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        this.assertNoPluginsMessage();
        this.administration.enablePluginModule("Issue Operations Plugin", "System Issue Operations", "com.atlassian.jira.plugin.system.issueoperations:log-work");
        this.assertNoPluginsMessage();
        this.administration.enablePluginModule("Custom Field Types & Searchers", "JIRA's system custom field types", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect");
        this.assertPluginsMessage();
        this.administration.reIndex();
        this.administration.enablePluginModule("Custom Field Types & Searchers", "JIRA's system custom field types", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        this.assertPluginsMessage();
        this.administration.reIndex();
        this.administration.disablePlugin("Issue Operations Plugin", "System Issue Operations");
        this.assertNoPluginsMessage();
        this.administration.disablePlugin("Custom Field Types & Searchers", "JIRA's system custom field types");
        this.assertNoPluginsMessage();
        this.administration.enablePlugin("Issue Operations Plugin", "System Issue Operations");
        this.assertNoPluginsMessage();
        this.administration.enablePlugin("Custom Field Types & Searchers", "JIRA's system custom field types");
        this.assertPluginsMessage();
    }

    private void _testShowHideFieldInFieldConfigurationNoEffect(String fieldConfigurationName) {
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).hideFields("Affects Version/s");
        this.assertNoFieldConfigurationMessage();
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).showFields("Affects Version/s");
        this.assertNoFieldConfigurationMessage();
    }

    private void _testShowHideFieldInFieldConfigurationHasEffect(String fieldConfigurationName) {
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).hideFields("Affects Version/s");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
        this.administration.fieldConfigurations().fieldConfiguration(fieldConfigurationName).showFields("Affects Version/s");
        this.assertFieldConfigurationMessage();
        this.administration.reIndex();
    }

    private void _testAddCustomFieldGlobalContext() {
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.assertNoCustomFieldMessage();
        String issue = this.navigation.issue().createIssue("monkey", "Bug", "Test");
        this.administration.customFields().removeCustomField(customFieldId);
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF");
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue);
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
    }

    private void _testAddCustomFieldSpecificContext(String[] projects, String[] issueTypes, String projectForIssue, String issueTypeForIssue) {
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", issueTypes, projects);
        this.assertNoCustomFieldMessage();
        String issue1 = this.navigation.issue().createIssue("third project", "Task", "Test");
        this.administration.customFields().removeCustomField(customFieldId);
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", issueTypes, projects);
        this.assertNoCustomFieldMessage();
        String issue2 = this.navigation.issue().createIssue(projectForIssue, issueTypeForIssue, "Test");
        this.administration.customFields().removeCustomField(customFieldId);
        customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", "UserCF", issueTypes, projects);
        this.assertCustomFieldMessage();
        this.navigation.issue().deleteIssue(issue1);
        this.navigation.issue().deleteIssue(issue2);
        this.administration.customFields().removeCustomField(customFieldId);
        this.administration.reIndex();
    }

    private void changeFieldConfigSchemeAndAssertMessage(String previousFieldConfigurationSchemeName, String newFieldConfigurationSchemeName, boolean shouldMessageBeDisplayed) {
        this.administration.project().associateFieldConfigurationScheme("monkey", newFieldConfigurationSchemeName);
        if (shouldMessageBeDisplayed) {
            this.assertNoFieldConfigurationMessage();
            this.administration.project().associateFieldConfigurationScheme("monkey", previousFieldConfigurationSchemeName);
            this.administration.reIndex();
            String issue = this.navigation.issue().createIssue("monkey", "Bug", "Test");
            this.administration.project().associateFieldConfigurationScheme("monkey", newFieldConfigurationSchemeName);
            this.assertFieldConfigurationMessage();
            this.navigation.issue().deleteIssue(issue);
            this.administration.reIndex();
        } else {
            this.assertNoFieldConfigurationMessage();
        }
    }

    private void assertVotingMessage() {
        this.assertMessage("Voting");
    }

    private void assertNoVotingMessage() {
        this.assertNoMessage("Voting");
    }

    private void assertTimeTrackingMessage() {
        this.assertMessage("Time Tracking");
    }

    private void assertNoTimeTrackingMessage() {
        this.assertNoMessage("Time Tracking");
    }

    private void assertFieldConfigurationMessage() {
        this.assertMessage("Field Configuration");
    }

    private void assertNoFieldConfigurationMessage() {
        this.assertNoMessage("Field Configuration");
    }

    private void assertCustomFieldMessage() {
        this.assertMessage("Custom Fields");
    }

    private void assertNoCustomFieldMessage() {
        this.assertNoMessage("Custom Fields");
    }

    private void assertPluginsMessage() {
        this.assertMessage("Plugins");
    }

    private void assertNoPluginsMessage() {
        this.assertNoMessage("Plugins");
    }

    private void assertMessage(String section) {
        this.assertions.getTextAssertions().assertTextPresent(new XPathLocator(this.tester, "//div[@id='adminMessages']"), "Administrator made configuration changes in section '" + section + "'");
    }

    private void assertNoMessage(String section) {
        this.assertions.getTextAssertions().assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='adminMessages']"), "Administrator made configuration changes in section '" + section + "'");
    }
}

