/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestManageTrackbacks
extends JIRAWebTest {
    private static final String ISSUE_WITH_TRACKBACKS = "HSP-1";
    private static final String ISSUE_ID_WITH_TRACKBACKS = "10000";

    public TestManageTrackbacks(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestTrackback.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testManageTrackbacks() {
        this._testManageTrackbackPermission();
        this._testTrackbackDelete();
    }

    private void _testManageTrackbackPermission() {
        TestManageTrackbacks.log("Test manage trackback link visibility");
        this.addUser("user", "pass", "pass", "user@invalid.com");
        this.logout();
        this.login("user", "pass");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.assertTextNotPresent("Manage Trackbacks");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.assertTextPresentBeforeText("Manage Trackbacks", "Trackbacks");
    }

    private void _testTrackbackDelete() {
        TestManageTrackbacks.log("Test delete trackbacks");
        this.gotoIssue(ISSUE_WITH_TRACKBACKS);
        this.clickLinkWithText("Manage Trackbacks");
        this.assertTextPresent("This page allows you to manage the trackback links for a particular issue.");
        this.clickLink("del_10000");
        this.submit("Delete");
        this.clickLink("del_10001");
        this.submit("Delete");
        this.assertTextPresent("There are no trackbacks for this issue.");
        this.navigation.issue().viewIssue(ISSUE_WITH_TRACKBACKS);
        this.assertTextNotPresent("Trackbacks");
        this.assertTextNotPresent("Manage Trackbacks");
    }
}

