/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.util.Predicate;
import java.io.File;
import java.io.FileFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLocator<T> {
    private final Class<T> klazz;
    private int level = Integer.MAX_VALUE;
    private boolean allowInner = true;
    private Predicate<Class<? extends T>> predicate = null;
    private FileFilter filenameFilter = null;
    private String pkg = null;

    public ClassLocator(Class<T> klazz) {
        this.klazz = klazz;
    }

    public int getLevel() {
        return this.level;
    }

    public ClassLocator<T> setLevel(int level) {
        this.level = level;
        return this;
    }

    public boolean isAllowInner() {
        return this.allowInner;
    }

    public ClassLocator<T> setAllowInner(boolean allowInner) {
        this.allowInner = allowInner;
        return this;
    }

    public Predicate<Class<? extends T>> getPredicate() {
        return this.predicate;
    }

    public ClassLocator<T> setPredicate(Predicate<Class<? extends T>> predicate) {
        this.predicate = predicate;
        return this;
    }

    public FileFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public ClassLocator<T> setFilenameFilter(FileFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
        return this;
    }

    public ClassLocator<T> setPackage(String pkg) {
        this.pkg = pkg;
        return this;
    }

    public String getPackage() {
        return this.pkg;
    }

    public List<Class<? extends T>> findClasses() {
        File directory;
        if (this.pkg == null) {
            throw new IllegalStateException("Package must be specified.");
        }
        String folderName = this.pkg.replace('.', '/');
        URL url = Thread.currentThread().getContextClassLoader().getResource(folderName);
        try {
            directory = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            directory = new File(url.getFile());
        }
        if (directory.exists() && directory.isDirectory()) {
            ArrayList<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();
            ClassPredicate<? extends T> classPredicate = new ClassPredicate<T>(this.predicate, this.klazz, this.allowInner);
            ClassFileFilter classFileFilter = new ClassFileFilter(this.allowInner, this.filenameFilter);
            ClassLocator.getClassesRecursively(this.pkg, directory, classes, classPredicate, classFileFilter, this.level);
            return classes;
        }
        throw new RuntimeException(this.pkg + " does not appear to be a valid package");
    }

    private static <T> void getClassesRecursively(String packageName, File directory, List<Class<? extends T>> classList, ClassPredicate<T> predicate, FileFilter filter, int currentLevel) {
        File[] childFiles;
        for (File childFile : childFiles = directory.listFiles(filter)) {
            if (childFile.isFile()) {
                String fileName = childFile.getName();
                String className = FilenameUtils.getBaseName((String)fileName);
                try {
                    Class<?> clazz = Class.forName(packageName + '.' + className);
                    Class<T> subClass = predicate.evaluate(clazz);
                    if (subClass == null) continue;
                    classList.add(subClass);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unexpected class not found exception for: " + className, e);
                }
            }
            if (!childFile.isDirectory() || currentLevel <= 0) continue;
            ClassLocator.getClassesRecursively(packageName + '.' + childFile.getName(), childFile, classList, predicate, filter, currentLevel - 1);
        }
    }

    private static class ClassFileFilter
    implements FileFilter {
        private static final String EXTENSION_CLASS = "class";
        private final boolean inner;
        private final FileFilter delegate;

        private ClassFileFilter(boolean inner, FileFilter delegate) {
            this.inner = inner;
            this.delegate = delegate;
        }

        public boolean accept(File pathname) {
            if (!pathname.exists() || !pathname.canRead()) {
                return false;
            }
            if (pathname.isFile() && !this.isValidClassFile(pathname)) {
                return false;
            }
            return this.delegate == null || this.delegate.accept(pathname);
        }

        private boolean isValidClassFile(File file) {
            String name = file.getName();
            String extension = FilenameUtils.getExtension((String)name);
            return EXTENSION_CLASS.equalsIgnoreCase(extension) && (this.inner || name.indexOf(36) < 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassPredicate<T> {
        private final Predicate<Class<? extends T>> delegate;
        private final Class<T> klazz;
        private final boolean inner;

        public ClassPredicate(Predicate<Class<? extends T>> delegate, Class<T> klazz, boolean inner) {
            this.delegate = delegate;
            this.klazz = klazz;
            this.inner = inner;
        }

        public Class<? extends T> evaluate(Class<?> input) {
            if (this.klazz.isAssignableFrom(input) && (this.inner || input.getEnclosingClass() == null)) {
                Class<?> subKlazz = input;
                if (this.delegate == null || this.delegate.evaluate(subKlazz)) {
                    return subKlazz;
                }
            }
            return null;
        }
    }
}

