/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.webtests.LicenseKeys;

public class TestXmlRestore
extends FuncTestCase {
    public TestXmlRestore(String name) {
        this.setName(name);
    }

    public void testRestoreDataWhereCurrentUserDoesntExist() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("idontexist");
        this.administration.usersAndGroups().addUserToGroup("idontexist", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("idontexist");
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("jiraform");
        String filePath = this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/blankprojects.xml";
        this.getTester().setFormElement("filename", filePath);
        this.getTester().setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.getTester().submit();
        this.getTester().assertTextPresent("Your project has been successfully imported");
        this.getTester().assertTextNotPresent("NullPointerException");
        this.navigation.login("admin", "admin");
        this.administration.generalConfiguration().setBaseUrl(this.getBaseUrl());
    }

    public void testRestoreWithCustomPathsErrors() {
        try {
            this.administration.restoreData("TestXMLRestore.xml");
        }
        catch (Throwable e) {
            TestXmlRestore.assertTrue((String)"custom path should not be created", (boolean)e.getMessage().startsWith("Failed to restore JIRA data. Cause: There is a problem with one or more of your file paths"));
        }
        this.tester.assertTextPresent("There is a problem with one or more of your file paths");
    }

    private String getBaseUrl() {
        return this.getEnvironmentData().getBaseUrl().toExternalForm();
    }
}

