/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebTable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public abstract class AbstractTestIssueNavigatorColumnsView
extends AbstractTestIssueNavigatorView {
    public AbstractTestIssueNavigatorColumnsView(String name) {
        super(name);
    }

    protected AbstractTestIssueNavigatorView.Item createItem1() {
        AbstractTestIssueNavigatorView.Item item = super.createItem1();
        item.setAttribute("rowId", "1");
        item.setAttribute("project", "homosapien");
        return item;
    }

    protected AbstractTestIssueNavigatorView.Item createItem2() {
        AbstractTestIssueNavigatorView.Item item = super.createItem2();
        item.setAttribute("rowId", "2");
        item.setAttribute("project", "homosapien");
        return item;
    }

    protected AbstractTestIssueNavigatorView.Item createItem3() {
        AbstractTestIssueNavigatorView.Item item = super.createItem3();
        item.setAttribute("rowId", "3");
        item.setAttribute("project", "homosapien");
        item.setAttribute("workRatio", "0%");
        return item;
    }

    protected class ItemVerifier {
        protected final AbstractTestIssueNavigatorColumnsView test;
        protected final AbstractTestIssueNavigatorView.Item item;
        protected final WebTable table;
        protected final int row;
        protected final URL baseUrl;

        public ItemVerifier(AbstractTestIssueNavigatorColumnsView test, AbstractTestIssueNavigatorView.Item item, WebTable table, URL baseUrl) {
            this.test = test;
            this.item = item;
            this.table = table;
            this.row = Integer.parseInt(item.getAttribute("rowId"));
            this.baseUrl = baseUrl;
        }

        public void verify() {
            String key = this.item.getAttribute("key");
            AbstractTestIssueNavigatorColumnsView.log("Checking item [" + key + "] on row [" + this.row + "]");
            String issueLink = this.baseUrl + "/browse/" + key;
            this.verifyLinkExists("issueType", issueLink);
            this.verifyLinkExists("issueKey", issueLink);
            this.verifyCellIssueAttributeEmptyOrEquals("issueSummary", "summary");
            this.verifyLinkExists("issueSummary", issueLink);
            this.verifyCellIssueAttributeEmptyOrEquals("issueAssignee", "assignee");
            this.verifyCellIssueAttributeEmptyOrEquals("issueReporter", "reporter");
            this.verifyImageExists("issuePriority", this.baseUrl + "/images/icons/" + AbstractTestIssueNavigatorView.ISSUE_PRIORITY_IMAGE_MAP.get(this.item.getAttribute("priority")));
            this.verifyCellIssueAttributeEmptyOrEquals("issueStatus", "status");
            String resolution = this.item.getAttribute("resolution");
            this.verifyCellValueEmptyOrEquals("issueResolution", resolution.equals("Unresolved") ? "Unresolved" : resolution);
            this.verifyCellIssueAttributeEmptyOrEquals("issueCreated", "created");
            this.verifyCellIssueAttributeEmptyOrEquals("issueUpdated", "updated");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDue", "due");
            this.verifyCellIssueAttributeEmptyOrEquals("issueAffectsVersions", "version");
            this.verifyCustomFieldDisplayValues("issueCascadingSelectField", "CascadingSelectField");
            for (String component : this.item.getComponents()) {
                this.verifyCellValueEmptyOrEquals("issueComponents", component);
            }
            this.verifyCustomFieldDisplayValues("issueDatePickerField", "DatePickerField");
            this.verifyCustomFieldDisplayValues("issueDateTimeField", "DateTimeField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueDescription", "description");
            this.verifyCellIssueAttributeEmptyOrEquals("issueEnvironment", "environment");
            this.verifyCellIssueAttributeEmptyOrEquals("issueFixVersions", "fixVersion");
            this.verifyCustomFieldDisplayValues("issueFreeTextField", "FreeTextField");
            this.verifyCustomFieldDisplayValues("issueGroupPickerField", "GroupPickerField");
            this.verifyCustomFieldDisplayValues("issueImportIdField", "ImportIdField");
            AbstractTestIssueNavigatorView.IssueLinks links = this.item.getLinks();
            for (AbstractTestIssueNavigatorView.IssueLink link : links.getInLinks()) {
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
                this.verifyLinkExists("issueLinks", link.getUrl());
            }
            for (AbstractTestIssueNavigatorView.IssueLink link : links.getOutLinks()) {
                this.verifyCellValueEmptyOrEquals("issueLinks", link.getLink());
                this.verifyLinkExists("issueLinks", link.getUrl());
            }
            this.verifyCustomFieldDisplayValues("issueMultiCheckboxesField", "MultiCheckboxesField");
            this.verifyCustomFieldDisplayValues("issueMultiGroupPickerField", "MultiGroupPickerField");
            this.verifyCustomFieldLinks("issueMultiGroupPickerField", "MultiGroupPickerField");
            this.verifyCustomFieldDisplayValues("issueMultiSelectField", "MultiSelectField");
            this.verifyCustomFieldDisplayValues("issueMultiUserPickerField", "MultiUserPickerField");
            this.verifyCustomFieldLinks("issueMultiUserPickerField", "MultiUserPickerField");
            this.verifyCustomFieldDisplayValues("issueNumberField", "NumberField");
            if ("days".equals(AbstractTestIssueNavigatorColumnsView.this.timeFormat)) {
                this.verifyCellIssueAttributeEmptyOrEquals("issueOriginalEstimate", "timeoriginalestimateDays");
                this.verifyCellIssueAttributeEmptyOrEquals("issueRemainingEstimate", "timeestimateDays");
                this.verifyCellIssueAttributeEmptyOrEquals("issueTimeSpent", "timespentDays");
            } else if ("hours".equals(AbstractTestIssueNavigatorColumnsView.this.timeFormat)) {
                this.verifyCellIssueAttributeEmptyOrEquals("issueOriginalEstimate", "timeoriginalestimateHours");
                this.verifyCellIssueAttributeEmptyOrEquals("issueRemainingEstimate", "timeestimateHours");
                this.verifyCellIssueAttributeEmptyOrEquals("issueTimeSpent", "timespentHours");
            } else {
                this.verifyCellIssueAttributeEmptyOrEquals("issueOriginalEstimate", "timeoriginalestimate");
                this.verifyCellIssueAttributeEmptyOrEquals("issueRemainingEstimate", "timeestimate");
                this.verifyCellIssueAttributeEmptyOrEquals("issueTimeSpent", "timespent");
            }
            this.verifyCellIssueAttributeEmptyOrEquals("issueProject", "project");
            this.verifyCustomFieldDisplayValues("issueProjectPickerField", "ProjectPickerField");
            this.verifyCustomFieldLinks("issueProjectPickerField", "ProjectPickerField");
            this.verifyCustomFieldDisplayValues("issueROTextField", "ROTextField");
            this.verifyCustomFieldDisplayValues("issueRadioButtonsField", "RadioButtonsField");
            this.verifyCustomFieldDisplayValues("issueSelectList", "SelectList");
            this.verifyCustomFieldDisplayValues("issueSingleVersionPickerField", "SingleVersionPickerField");
            this.verifyCustomFieldLinks("issueSingleVersionPickerField", "SingleVersionPickerField");
            this.verifyCustomFieldDisplayValues("issueTextField255", "TextField255");
            this.verifyCustomFieldDisplayValues("issueURLField", "URLField");
            this.verifyCustomFieldLinks("issueURLField", "URLField");
            this.verifyCustomFieldDisplayValues("issueUserPickerField", "UserPickerField");
            this.verifyCustomFieldLinks("issueUserPickerField", "UserPickerField");
            this.verifyCustomFieldDisplayValues("issueVersionPickerField", "VersionPickerField");
            this.verifyCustomFieldLinks("issueVersionPickerField", "VersionPickerField");
            this.verifyCellIssueAttributeEmptyOrEquals("issueVotes", "votes");
            this.verifyCellIssueAttributeEmptyOrEquals("issueWorkRatio", "workRatio");
        }

        protected void verifyImageExists(String fieldName, String imageUrl) {
            AbstractTestIssueNavigatorColumnsView.this.assertTableCellHasImage(this.table, this.row, this.getColumn(fieldName), imageUrl);
        }

        protected void verifyLinkExists(String fieldName, String link) {
            Assert.assertTrue((boolean)this.test.tableCellHasLinkThatContains(this.table, this.row, this.getColumn(fieldName), link));
        }

        protected int getColumn(String key) {
            return AbstractTestIssueNavigatorColumnsView.this.issueFieldColumnMap.indexOf(key);
        }

        protected void verifyCellIssueAttributeEmptyOrEquals(String fieldName, String itemFieldName) {
            String fieldValue = this.item.getAttribute(itemFieldName);
            this.verifyCellValueEmptyOrEquals(fieldName, fieldValue);
        }

        protected void verifyCellValueEmptyOrEquals(String fieldName, String fieldExpectedValue) {
            if (fieldExpectedValue != null) {
                if ("NOT TESTED".equals(fieldExpectedValue)) {
                    String cellAsText = this.table.getCellAsText(this.row, this.getColumn(fieldName));
                    Assert.assertNotNull((Object)cellAsText);
                    Assert.assertTrue((cellAsText.trim().length() > 0 ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((boolean)this.test.tableCellHasText(this.table, this.row, this.getColumn(fieldName), fieldExpectedValue));
                }
            } else {
                String cellAsText = this.table.getCellAsText(this.row, this.getColumn(fieldName));
                if (cellAsText != null) {
                    Assert.assertEquals((String)"", (String)cellAsText.trim());
                }
            }
        }

        protected void verifyCustomFieldDisplayValues(String columnKey, String customFieldName) {
            AbstractTestIssueNavigatorView.CustomField customField = this.item.getCustomFieldByName(customFieldName);
            if (customField != null) {
                List values = customField.getValues();
                for (AbstractTestIssueNavigatorView.CustomField.Value value : values) {
                    int column = this.getColumn(columnKey);
                    Assert.assertTrue((boolean)this.test.tableCellHasText(this.table, this.row, column, value.getDisplayValue()));
                }
            } else {
                this.verifyCellValueEmptyOrEquals(columnKey, null);
            }
        }

        protected void verifyCustomFieldLinks(String columnKey, String customFieldName) {
            AbstractTestIssueNavigatorView.CustomField customField = this.item.getCustomFieldByName(customFieldName);
            if (customField != null) {
                List values = customField.getValues();
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    String link = ((AbstractTestIssueNavigatorView.CustomField.Value)i.next()).getLink();
                    if (link != null) {
                        int column = this.getColumn(columnKey);
                        Assert.assertTrue((boolean)this.test.tableCellHasLinkThatContains(this.table, this.row, column, link));
                        continue;
                    }
                    Assert.fail((String)"link not defined");
                }
            }
        }
    }
}

