/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.util.concurrent.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformingIterable<I, O>
implements EnclosedIterable<O> {
    private final EnclosedIterable<I> delegate;
    private final Function<I, O> transformer;

    TransformingIterable(@NotNull EnclosedIterable<I> delegate, @NotNull Function<I, O> transformer) {
        this.delegate = (EnclosedIterable)Assertions.notNull((String)"delegate", delegate);
        this.transformer = (Function)Assertions.notNull((String)"decorator", transformer);
    }

    @Override
    public void foreach(final Consumer<O> sink) {
        this.delegate.foreach(new Consumer<I>(){

            @Override
            public void consume(I element) {
                sink.consume(TransformingIterable.this.transformer.get(element));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }
}

