/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class LRUMap<K, V>
extends LinkedHashMap<K, V>
implements Map<K, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int maxSize;

    public static <K, V> Map<K, V> newLRUMap(int capacity) {
        return new LRUMap<K, V>(capacity);
    }

    public static <K, V> Map<K, V> synchronizedLRUMap(int capacity) {
        return Collections.synchronizedMap(LRUMap.newLRUMap(capacity));
    }

    LRUMap(int capacity) {
        super(capacity, 0.75f, true);
        this.maxSize = capacity;
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }
}

