/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.text;

import com.atlassian.jira.functest.framework.util.text.TextKit;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class TestTextKit
extends TestCase {
    public void testCollapseWhitespace() {
        TestTextKit.assertNull((Object)TextKit.collapseWhitespace(null));
        TestTextKit.assertEquals((String)"", (String)TextKit.collapseWhitespace(""));
        TestTextKit.assertEquals((String)"", (String)TextKit.collapseWhitespace("     \n  \t "));
        TestTextKit.assertEquals((String)"Hello World.", (String)TextKit.collapseWhitespace("     \n  \t Hello\n\n\nWorld.  "));
    }

    public void testEqualsCollapseWhiteSpace() {
        TestTextKit.assertTrue((boolean)TextKit.equalsCollapseWhiteSpace(null, null));
        TestTextKit.assertTrue((boolean)TextKit.equalsCollapseWhiteSpace("", ""));
        TestTextKit.assertTrue((boolean)TextKit.equalsCollapseWhiteSpace(" hello", "hello  "));
        TestTextKit.assertTrue((boolean)TextKit.equalsCollapseWhiteSpace("hello", " hello   "));
        TestTextKit.assertTrue((boolean)TextKit.equalsCollapseWhiteSpace("  hello world\n", "hello\t\tworld"));
        TestTextKit.assertFalse((boolean)TextKit.equalsCollapseWhiteSpace(null, ""));
        TestTextKit.assertFalse((boolean)TextKit.equalsCollapseWhiteSpace("", null));
        TestTextKit.assertFalse((boolean)TextKit.equalsCollapseWhiteSpace("helloworld", "hello world"));
    }

    public void testGetNumOccurencesIllegalArguments() throws Exception {
        try {
            TestTextKit.assertEquals((int)0, (int)TextKit.getNumOccurences("A", null));
            TestTextKit.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            TestTextKit.assertEquals((int)0, (int)TextKit.getNumOccurences(null, "A"));
            TestTextKit.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            TestTextKit.assertEquals((int)0, (int)TextKit.getNumOccurences("A", ""));
            TestTextKit.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetNumOccurences() throws Exception {
        TestTextKit.assertEquals((int)0, (int)TextKit.getNumOccurences("", "A"));
        TestTextKit.assertEquals((int)0, (int)TextKit.getNumOccurences(" asdf asd", "A"));
        TestTextKit.assertEquals((int)1, (int)TextKit.getNumOccurences("Apple", "Apple"));
        TestTextKit.assertEquals((int)2, (int)TextKit.getNumOccurences("AppleAppleasdf", "Apple"));
        TestTextKit.assertEquals((int)2, (int)TextKit.getNumOccurences("BananaAppleApple", "Apple"));
        TestTextKit.assertEquals((int)2, (int)TextKit.getNumOccurences("fresh Apple pie fresh Apple pie", "Apple"));
        TestTextKit.assertEquals((int)2, (int)TextKit.getNumOccurences("babababa", "baba"));
    }

    public void testAssertContainsTextSequence() {
        try {
            TextKit.assertContainsTextSequence(null, new String[]{"a"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            TextKit.assertContainsTextSequence("asdf", null);
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        TextKit.assertContainsTextSequence("", new String[0]);
        TextKit.assertContainsTextSequence("X", new String[0]);
        try {
            TextKit.assertContainsTextSequence("", new String[]{"a"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 1st member of the expectedTextSequence: 'a'.");
        }
        TextKit.assertContainsTextSequence("a", new String[]{"a"});
        try {
            TextKit.assertContainsTextSequence("a", new String[]{"a", "a"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 2nd member of the expectedTextSequence: 'a'.");
        }
        TextKit.assertContainsTextSequence("aa", new String[]{"a", "a"});
        try {
            TextKit.assertContainsTextSequence("aa", new String[]{"a", "a", "a"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 3rd member of the expectedTextSequence: 'a'.");
        }
        TextKit.assertContainsTextSequence("cathat", new String[]{"cat", "hat"});
        TextKit.assertContainsTextSequence("cat hat", new String[]{"cat", "hat"});
        TextKit.assertContainsTextSequence("The cat that ate the mouse.", new String[]{"cat", "hat"});
        TextKit.assertContainsTextSequence("The cat that ate the mouse.", new String[]{"The", "hat", "mouse"});
        try {
            TextKit.assertContainsTextSequence("The cat that ate the mouse.", new String[]{"The", "mouse", "hat"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 3rd member of the expectedTextSequence: 'hat'.");
        }
        try {
            TextKit.assertContainsTextSequence("cathat", new String[]{"cat", "that"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 2nd member of the expectedTextSequence: 'that'.");
        }
        TextKit.assertContainsTextSequence("AABBCC", new String[]{"AA", "BB", "CC"});
        try {
            TextKit.assertContainsTextSequence("BBCCAABB", new String[]{"AA", "BB", "CC"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 3rd member of the expectedTextSequence: 'CC'.");
        }
        try {
            TextKit.assertContainsTextSequence("AA BB CC", new String[]{"AA", "BB", "CC", "AA"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 4th member of the expectedTextSequence: 'AA'.");
        }
        try {
            TextKit.assertContainsTextSequence("the quick brown fox jumped over the lazy dog backwards", new String[]{"the", "quick", "brown", "fox", "jumped", "over", "the", "lazy", "dog", "backwards", "again"});
            TestTextKit.fail((String)"Assertion should have failed.");
        }
        catch (AssertionFailedError ex) {
            this.assertHasMessage(ex, "Sequence assertion failed on the 11th member of the expectedTextSequence: 'again'.");
        }
    }

    private void assertHasMessage(AssertionFailedError ex, String message) {
        TestTextKit.assertTrue((String)("Doesnt have message : " + message), (ex.getMessage().indexOf(message) == 0 ? 1 : 0) != 0);
    }

    public void testContainsTextSequence() throws Exception {
        try {
            TextKit.containsTextSequence(null, new String[]{"a"});
            TestTextKit.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("asdf", null));
            TestTextKit.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("", new String[0]));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("X", new String[0]));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("", new String[]{"a"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("a", new String[]{"a"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("a", new String[]{"a", "a"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("aa", new String[]{"a", "a"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("aa", new String[]{"a", "a", "a"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("cathat", new String[]{"cat", "hat"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("cat hat", new String[]{"cat", "hat"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("The cat that ate the mouse.", new String[]{"cat", "hat"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("The cat that ate the mouse.", new String[]{"The", "hat", "mouse"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("The cat that ate the mouse.", new String[]{"The", "mouse", "hat"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("cathat", new String[]{"cat", "that"}));
        TestTextKit.assertTrue((boolean)TextKit.containsTextSequence("AABBCC", new String[]{"AA", "BB", "CC"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("BBCCAABB", new String[]{"AA", "BB", "CC"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("AA BB CC", new String[]{"AA", "BB", "CC", "AA"}));
        TestTextKit.assertFalse((boolean)TextKit.containsTextSequence("the quick brown fox jumped over the lazy dog backwards", new String[]{"the", "quick", "brown", "fox", "jumped", "over", "the", "lazy", "dog", "backwards", "again"}));
    }
}

