/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigException;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.ConfigSequence;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import com.atlassian.jira.functest.unittests.config.DefaultConfigServiceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultConfigServiceManager
extends TestCase {
    private static final String ELEMENT_SERVICE_CONFIG = "ServiceConfig";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_CLAZZ = "clazz";
    private static final String ATTRIBUTE_NAME = "name";
    private ConfigService service1;
    private ConfigService service2;
    private ConfigService service3;

    protected void setUp() throws Exception {
        super.setUp();
        this.service1 = new ConfigService().setId(100L).setName("qwerty").setClazz("blarg").setTimeout(738L);
        ConfigPropertySet cps = new ConfigPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId());
        cps.setStringProperty("one", "one");
        this.service1.setPropertySet(cps);
        this.service2 = new ConfigService().setId(1001L).setName("asdfgh").setClazz("aajaja").setTimeout(3773L);
        cps = new ConfigPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId());
        cps.setStringProperty("two", "two");
        this.service2.setPropertySet(cps);
        this.service3 = new ConfigService().setId(2266272L).setName("zxcvbn").setClazz("jjksks").setTimeout(383838L);
        cps = new ConfigPropertySet(ELEMENT_SERVICE_CONFIG, this.service3.getId());
        cps.setStringProperty("three", "three");
        this.service3.setPropertySet(cps);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.service3 = null;
        this.service2 = null;
        this.service1 = null;
    }

    public void testReadServices() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)new ConfigPropertySet(this.service1.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId())).andReturn((Object)new ConfigPropertySet(this.service2.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service3.getId())).andReturn((Object)new ConfigPropertySet(this.service3.getPropertySet()));
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1, this.service2, this.service3}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        List<ConfigService> actualList = manager.loadServices();
        this.assertEqualsCollections(actualList, Arrays.asList(this.service1, this.service2, this.service3));
        control.verify();
    }

    public void testReadServicesNoId() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1.setId(null)}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        try {
            List<ConfigService> actualList = manager.loadServices();
            TestDefaultConfigServiceManager.fail((String)("Expected exception but got list: " + actualList));
        }
        catch (ConfigException e) {
            // empty catch block
        }
        control.verify();
    }

    public void testSaveServicesNew() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)new ConfigPropertySet(this.service1.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.savePropertySet(this.service2.getPropertySet())).andReturn((Object)true);
        EasyMock.expect((Object)sequence.getNextId(ELEMENT_SERVICE_CONFIG)).andReturn((Object)this.service2.getId());
        EasyMock.expect((Object)propertySetManager.savePropertySet(this.service3.getPropertySet())).andReturn((Object)false);
        EasyMock.expect((Object)sequence.getNextId(ELEMENT_SERVICE_CONFIG)).andReturn((Object)this.service3.getId());
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        TestDefaultConfigServiceManager.assertTrue((boolean)manager.saveServices(Arrays.asList(this.service1, this.service2, this.service3)));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(Arrays.asList(this.service1, this.service2, this.service3));
        control.verify();
    }

    public void testSaveServicesDelete() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)new ConfigPropertySet(this.service1.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId())).andReturn((Object)new ConfigPropertySet(this.service2.getPropertySet()));
        propertySetManager.deletePropertySet(this.service2.getPropertySet());
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1, this.service2}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        TestDefaultConfigServiceManager.assertTrue((boolean)manager.saveServices(Arrays.asList(this.service1)));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(Arrays.asList(this.service1));
        control.verify();
    }

    public void testSaveServicesDeleteAll() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)new ConfigPropertySet(this.service1.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId())).andReturn((Object)new ConfigPropertySet(this.service2.getPropertySet()));
        propertySetManager.deletePropertySet(this.service1.getPropertySet());
        propertySetManager.deletePropertySet(this.service2.getPropertySet());
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1, this.service2}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        TestDefaultConfigServiceManager.assertTrue((boolean)manager.saveServices(Collections.<ConfigService>emptyList()));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(Collections.emptyList());
        control.verify();
    }

    public void testSaveServicesDeleteNoId() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1.setId(null), this.service2}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        try {
            manager.saveServices(Collections.<ConfigService>emptyList());
            TestDefaultConfigServiceManager.fail((String)"Error expected.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        control.verify();
    }

    public void testUpdateService() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service3.getId())).andReturn((Object)this.service3.getPropertySet());
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)this.service1.getPropertySet());
        EasyMock.expect((Object)propertySetManager.savePropertySet(this.service3.getPropertySet())).andReturn((Object)false);
        EasyMock.expect((Object)propertySetManager.savePropertySet(this.service1.getPropertySet())).andReturn((Object)false);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service3, this.service1}).createDocument();
        control.replay();
        this.service3.setName("newName");
        this.service3.setTimeout(190387483L);
        this.service3.setClazz("this.Is.A.Very.Random.Clazzz");
        this.service1.setName(null);
        this.service1.setTimeout(null);
        this.service1.setClazz(null);
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        List<ConfigService> expectedServices = Arrays.asList(this.service3, this.service1);
        TestDefaultConfigServiceManager.assertTrue((boolean)manager.saveServices(expectedServices));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(expectedServices);
        control.verify();
    }

    public void testUpdateServicePropertySetChange() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        ConfigPropertySet cps = this.service2.getPropertySet().copyForEntity("bad", 12L);
        cps.setLongProperty("New", 67L);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)new ConfigPropertySet(this.service1.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId())).andReturn((Object)new ConfigPropertySet(this.service2.getPropertySet()));
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service3.getId())).andReturn(null);
        propertySetManager.deletePropertySet(this.service1.getPropertySet());
        EasyMock.expect((Object)propertySetManager.savePropertySet(cps.copyForEntity(ELEMENT_SERVICE_CONFIG, this.service2.getId()))).andReturn((Object)true);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1, this.service2, this.service3}).createDocument();
        control.replay();
        this.service1.setPropertySet(null);
        this.service2.setPropertySet(cps);
        this.service3.setPropertySet(null).setName("nsnskajksfjalkdjfldksjfdlks");
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        List<ConfigService> expectedServices = Arrays.asList(this.service1, this.service2, this.service3);
        TestDefaultConfigServiceManager.assertTrue((boolean)manager.saveServices(expectedServices));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(expectedServices);
        control.verify();
    }

    public void testUpdateServicesNoId() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service1.setId(null), this.service2}).createDocument();
        control.replay();
        this.service1.setName("somethineNew");
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        try {
            manager.saveServices(Arrays.asList(this.service1, this.service2));
            TestDefaultConfigServiceManager.fail((String)"Error expected.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        control.verify();
    }

    public void testSaveNoChanges() throws Exception {
        IMocksControl control = EasyMock.createControl();
        ConfigPropertySetManager propertySetManager = (ConfigPropertySetManager)control.createMock(ConfigPropertySetManager.class);
        ConfigSequence sequence = (ConfigSequence)control.createMock(ConfigSequence.class);
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service3.getId())).andReturn((Object)this.service3.getPropertySet());
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service1.getId())).andReturn((Object)this.service1.getPropertySet());
        EasyMock.expect((Object)propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, this.service2.getId())).andReturn((Object)this.service2.getPropertySet());
        DocumentBuilder helper = new DocumentBuilder();
        Document document = helper.addServices(new ConfigService[]{this.service3, this.service1, this.service2}).createDocument();
        control.replay();
        DefaultConfigServiceManager manager = new DefaultConfigServiceManager(document, propertySetManager, sequence);
        List<ConfigService> expectedServices = Arrays.asList(this.service3, this.service1, this.service2);
        TestDefaultConfigServiceManager.assertFalse((boolean)manager.saveServices(expectedServices));
        DocumentAsserter documentParser = new DocumentAsserter(document);
        documentParser.assertServices(expectedServices);
        control.verify();
    }

    private void assertEqualsCollections(Collection<?> one, Collection<?> two) {
        TestDefaultConfigServiceManager.assertEquals((String)String.format("size(%s) != size(%s)", one, two), (int)one.size(), (int)two.size());
        TestDefaultConfigServiceManager.assertTrue((String)String.format("%s != %s", one, two), (boolean)one.containsAll(two));
    }

    private static class DocumentBuilder {
        private Element root;

        private DocumentBuilder() {
            this(DocumentBuilder.createRoot());
        }

        private DocumentBuilder(Document document) {
            this.root = document.getRootElement();
        }

        private Document createDocument() {
            return DocumentBuilder.createDocumentWithRoot(this.root.createCopy());
        }

        private DocumentBuilder addServices(ConfigService ... services) {
            for (ConfigService service : services) {
                this.addService(service);
            }
            return this;
        }

        private DocumentBuilder addService(ConfigService service) {
            Element element = this.root.addElement(TestDefaultConfigServiceManager.ELEMENT_SERVICE_CONFIG);
            ConfigXmlUtils.setAttribute(element, TestDefaultConfigServiceManager.ATTRIBUTE_ID, DocumentBuilder.asString(service.getId()));
            ConfigXmlUtils.setAttribute(element, TestDefaultConfigServiceManager.ATTRIBUTE_NAME, service.getName());
            ConfigXmlUtils.setAttribute(element, TestDefaultConfigServiceManager.ATTRIBUTE_CLAZZ, service.getClazz());
            ConfigXmlUtils.setAttribute(element, TestDefaultConfigServiceManager.ATTRIBUTE_TIME, DocumentBuilder.asString(service.getTimeout()));
            return this;
        }

        private static Document createRoot() {
            DocumentFactory factory = DocumentFactory.getInstance();
            Document document = factory.createDocument();
            document.addElement("entity-engine-xml");
            return document;
        }

        private static Document createDocumentWithRoot(Element root) {
            DocumentFactory factory = DocumentFactory.getInstance();
            Document document = factory.createDocument();
            document.add(root);
            return document;
        }

        private static String asString(Object obj) {
            return obj == null ? null : obj.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentAsserter {
        private final Document doc;

        public DocumentAsserter(Document doc) {
            this.doc = doc;
        }

        private void assertServices(List<ConfigService> expectedServices) {
            List<ConfigService> actualServices = this.readServices();
            Assert.assertEquals((String)String.format("size(%s) != size(%s)", expectedServices, actualServices), (int)expectedServices.size(), (int)actualServices.size());
            Iterator<ConfigService> actualIter = actualServices.iterator();
            for (ConfigService expectedService : expectedServices) {
                ConfigService actualService;
                if (this.checkServiceEquals(expectedService, actualService = actualIter.next())) continue;
                Assert.fail((String)String.format("Expected(%s) != Actual(%s)", expectedService, actualService));
            }
        }

        private List<ConfigService> readServices() {
            List elements = this.doc.getRootElement().elements(TestDefaultConfigServiceManager.ELEMENT_SERVICE_CONFIG);
            ArrayList<ConfigService> services = new ArrayList<ConfigService>(elements.size());
            for (Element element : elements) {
                services.add(this.readService(element));
            }
            return services;
        }

        private ConfigService readService(Element element) {
            ConfigService service = new ConfigService();
            service.setId(ConfigXmlUtils.getLongValue(element, TestDefaultConfigServiceManager.ATTRIBUTE_ID));
            service.setName(ConfigXmlUtils.getTextValue(element, TestDefaultConfigServiceManager.ATTRIBUTE_NAME));
            service.setClazz(ConfigXmlUtils.getTextValue(element, TestDefaultConfigServiceManager.ATTRIBUTE_CLAZZ));
            service.setTimeout(ConfigXmlUtils.getLongValue(element, TestDefaultConfigServiceManager.ATTRIBUTE_TIME));
            return service;
        }

        private boolean checkServiceEquals(ConfigService expected, ConfigService actual) {
            return new EqualsBuilder().append((Object)expected.getId(), (Object)actual.getId()).append((Object)expected.getTimeout(), (Object)actual.getTimeout()).append((Object)actual.getClazz(), (Object)expected.getClazz()).append((Object)actual.getName(), (Object)expected.getName()).isEquals();
        }
    }
}

