/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import com.atlassian.jira.functest.unittests.config.DefaultConfigSequence;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultConfigSequence
extends TestCase {
    private static final String TYPE_A = "a";
    private static final String TYPE_B = "b";
    private static final String TYPE_C = "c";
    private static final String TYPE_D = "d";
    private static final String ATTRIB_SEQ_NAME = "seqName";
    private static final String ATTRIB_SEQ_ID = "seqId";
    private static final String ELEMENT_SEQUENCE_VALUE_ITEM = "SequenceValueItem";

    public void testEmptySequence() throws Exception {
        Element element = TestDefaultConfigSequence.createRootElement();
        DefaultConfigSequence sequence = new DefaultConfigSequence(element.getDocument());
        TestDefaultConfigSequence.assertEquals((long)10000L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10001L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10000L, (long)sequence.getNextId(TYPE_B));
        TestDefaultConfigSequence.assertEquals((long)10002L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10001L, (long)sequence.getNextId(TYPE_B));
        TestDefaultConfigSequence.assertTrue((boolean)sequence.save());
        MapBuilder<String, Long> builder = MapBuilder.newBuilder().add(TYPE_A, 10010L).add(TYPE_B, 10010L);
        this.assertEntries(builder.toImmutableMap(), element.getDocument());
        TestDefaultConfigSequence.assertEquals((long)10003L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertFalse((boolean)sequence.save());
        this.assertEntries(builder.toImmutableMap(), element.getDocument());
    }

    public void testExistingSequence() throws Exception {
        Element root = TestDefaultConfigSequence.createRootElement();
        this.addEntry(root, TYPE_A, 10009L);
        this.addEntry(root, TYPE_B, 10016L);
        this.addEntry(root, TYPE_C, "jackLivesHere");
        DefaultConfigSequence sequence = new DefaultConfigSequence(root.getDocument());
        TestDefaultConfigSequence.assertEquals((long)10010L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10011L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10017L, (long)sequence.getNextId(TYPE_B));
        TestDefaultConfigSequence.assertEquals((long)10012L, (long)sequence.getNextId(TYPE_A));
        TestDefaultConfigSequence.assertEquals((long)10018L, (long)sequence.getNextId(TYPE_B));
        TestDefaultConfigSequence.assertEquals((long)10000L, (long)sequence.getNextId(TYPE_C));
        TestDefaultConfigSequence.assertEquals((long)10000L, (long)sequence.getNextId(TYPE_D));
        TestDefaultConfigSequence.assertEquals((long)10019L, (long)sequence.getNextId(TYPE_B));
        TestDefaultConfigSequence.assertTrue((boolean)sequence.save());
        MapBuilder<String, Long> builder = MapBuilder.newBuilder().add(TYPE_A, 10020L).add(TYPE_B, 10030L).add(TYPE_C, 10010L).add(TYPE_D, 10010L);
        this.assertEntries(builder.toImmutableMap(), root.getDocument());
        TestDefaultConfigSequence.assertFalse((boolean)sequence.save());
        TestDefaultConfigSequence.assertEquals((long)10001L, (long)sequence.getNextId(TYPE_C));
        TestDefaultConfigSequence.assertEquals((long)10001L, (long)sequence.getNextId(TYPE_D));
        TestDefaultConfigSequence.assertFalse((boolean)sequence.save());
        for (int i = 1; i <= 10; ++i) {
            TestDefaultConfigSequence.assertEquals((long)(10001L + (long)i), (long)sequence.getNextId(TYPE_C));
        }
        TestDefaultConfigSequence.assertTrue((boolean)sequence.save());
        this.assertEntries(builder.add(TYPE_C, 10020L).toImmutableMap(), root.getDocument());
    }

    private void addEntry(Element root, String type, long l) {
        this.addEntry(root, type, String.valueOf(l));
    }

    private void addEntry(Element root, String type, String value) {
        Element element = root.addElement(ELEMENT_SEQUENCE_VALUE_ITEM);
        ConfigXmlUtils.setAttribute(element, ATTRIB_SEQ_NAME, type);
        ConfigXmlUtils.setAttribute(element, ATTRIB_SEQ_ID, value);
    }

    private void assertEntries(Map<String, Long> expected, Document actual) {
        HashMap<String, Long> actualMap = new HashMap<String, Long>();
        List list = actual.selectNodes("/entity-engine-xml/SequenceValueItem");
        for (Node node : list) {
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            String name = ConfigXmlUtils.getTextValue(elem, ATTRIB_SEQ_NAME);
            Long value = ConfigXmlUtils.getLongValue(elem, ATTRIB_SEQ_ID);
            actualMap.put(name, value);
        }
        TestDefaultConfigSequence.assertEquals(expected, actualMap);
    }

    private static Element createRootElement() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        return document.addElement("entity-engine-xml");
    }
}

