/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import java.util.List;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.dom.DOMElement;

public class TestConfigXmlUtils
extends TestCase {
    private static final String WHITESPACE = "\n    ";

    public void testCreateNewElementBlank() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        Element newElement = ConfigXmlUtils.createNewElement(root, "cool");
        List list = root.content();
        TestConfigXmlUtils.assertTrue((boolean)(list.get(0) instanceof Text));
        TestConfigXmlUtils.assertEquals((String)WHITESPACE, (String)((Node)list.get(0)).getText());
        TestConfigXmlUtils.assertSame(list.get(1), (Object)newElement);
    }

    public void testCreateNewElementNoOthers() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        for (int i = 0; i < 5; ++i) {
            root.addElement("a").setText(String.valueOf(i));
        }
        Element newElement = ConfigXmlUtils.createNewElement(root, "addme");
        List list = root.content();
        TestConfigXmlUtils.assertTrue((boolean)(list.get(0) instanceof Text));
        TestConfigXmlUtils.assertEquals((String)WHITESPACE, (String)((Node)list.get(0)).getText());
        TestConfigXmlUtils.assertSame(list.get(1), (Object)newElement);
    }

    public void testCreateNewElementOthersAlreadyThere() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        root.addElement("a");
        root.addElement("b");
        root.addElement("c");
        Element newElement = ConfigXmlUtils.createNewElement(root, "b");
        List list = root.content();
        TestConfigXmlUtils.assertTrue((boolean)(list.get(2) instanceof Text));
        TestConfigXmlUtils.assertEquals((String)WHITESPACE, (String)((Node)list.get(2)).getText());
        TestConfigXmlUtils.assertSame(list.get(3), (Object)newElement);
    }

    public void testRemoveAttribute() throws Exception {
        String REMOVE = "remove";
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        root.addAttribute("remove", "me");
        ConfigXmlUtils.removeAttribute(root, "remove");
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
        root.addElement("remove").setText("somecrap");
        ConfigXmlUtils.removeAttribute(root, "remove");
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
        root.addAttribute("remove", "me");
        root.addElement("remove").setText("somecrap");
        ConfigXmlUtils.removeAttribute(root, "remove");
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
    }

    public void testSetAttributeRemove() throws Exception {
        String REMOVE = "remove";
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        root.addAttribute("remove", "me");
        root.addElement("remove").setText("somecrap");
        ConfigXmlUtils.setAttribute(root, "remove", null);
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
        TestConfigXmlUtils.assertNull((Object)root.element("remove"));
    }

    public void testSetAttributeXmlAttribute() throws Exception {
        String ATTRIB = "attrib";
        String NEW = "new";
        String NEWER = "newer";
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        ConfigXmlUtils.setAttribute(root, "attrib", "new");
        TestConfigXmlUtils.assertEquals((String)"new", (String)root.attributeValue("attrib"));
        root.addElement("attrib").setText("value");
        ConfigXmlUtils.setAttribute(root, "attrib", "newer");
        TestConfigXmlUtils.assertEquals((String)"newer", (String)root.attributeValue("attrib"));
        TestConfigXmlUtils.assertNull((Object)root.element("attrib"));
    }

    public void testSetAttributeXmlElement() throws Exception {
        String ATTRIB = "attrib";
        String NEW = "n\new";
        String NEWER = "ne\rwer";
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        ConfigXmlUtils.setAttribute(root, "attrib", "n\new");
        TestConfigXmlUtils.assertNull((Object)root.attribute("attrib"));
        TestConfigXmlUtils.assertEquals((String)"n\new", (String)root.element("attrib").getText());
        root.addAttribute("attrib", "Value");
        ConfigXmlUtils.setAttribute(root, "attrib", "ne\rwer");
        TestConfigXmlUtils.assertNull((Object)root.attribute("attrib"));
        TestConfigXmlUtils.assertEquals((String)"ne\rwer", (String)root.element("attrib").getText());
    }

    public void testGetStringValue() throws Exception {
        String ATTRIB = "attrib";
        String NEW = "new";
        String NEWER = "ne\rwer";
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        TestConfigXmlUtils.assertNull((Object)ConfigXmlUtils.getTextValue(root, "attrib"));
        root.addAttribute("attrib", "new");
        TestConfigXmlUtils.assertEquals((String)"new", (String)ConfigXmlUtils.getTextValue(root, "attrib"));
        root.addElement("attrib").setText("ne\rwer");
        TestConfigXmlUtils.assertEquals((String)"new", (String)ConfigXmlUtils.getTextValue(root, "attrib"));
        root.remove(root.attribute("attrib"));
        TestConfigXmlUtils.assertEquals((String)"ne\rwer", (String)ConfigXmlUtils.getTextValue(root, "attrib"));
    }

    public void testGetLongValue() throws Exception {
        String ATTRIB = "attrib";
        long NEW = 1L;
        long NEWER = 3345L;
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        TestConfigXmlUtils.assertNull((Object)ConfigXmlUtils.getLongValue(root, "attrib"));
        root.addAttribute("attrib", String.valueOf(1L));
        TestConfigXmlUtils.assertEquals((long)1L, (long)ConfigXmlUtils.getLongValue(root, "attrib"));
        root.addElement("attrib").setText(String.valueOf(3345L));
        TestConfigXmlUtils.assertEquals((long)1L, (long)ConfigXmlUtils.getLongValue(root, "attrib"));
        root.remove(root.attribute("attrib"));
        TestConfigXmlUtils.assertEquals((long)3345L, (long)ConfigXmlUtils.getLongValue(root, "attrib"));
        root.addAttribute("attrib", "badnumber");
        TestConfigXmlUtils.assertNull((Object)ConfigXmlUtils.getLongValue(root, "attrib"));
    }

    public void testGetIntValue() throws Exception {
        String ATTRIB = "attrib";
        boolean NEW = true;
        int NEWER = 3345;
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        TestConfigXmlUtils.assertNull((Object)ConfigXmlUtils.getIntegerValue(root, "attrib"));
        root.addAttribute("attrib", String.valueOf(1));
        TestConfigXmlUtils.assertEquals((int)1, (int)ConfigXmlUtils.getIntegerValue(root, "attrib"));
        root.addElement("attrib").setText(String.valueOf(3345));
        TestConfigXmlUtils.assertEquals((int)1, (int)ConfigXmlUtils.getIntegerValue(root, "attrib"));
        root.remove(root.attribute("attrib"));
        TestConfigXmlUtils.assertEquals((int)3345, (int)ConfigXmlUtils.getIntegerValue(root, "attrib"));
        root.addAttribute("attrib", "badnumber");
        TestConfigXmlUtils.assertNull((Object)ConfigXmlUtils.getIntegerValue(root, "attrib"));
    }

    public void testRemoveElementWithoutWhiteSpace() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        Element removeElement = root.addElement("removeMe");
        Element newFirst = root.addElement("newFirst");
        TestConfigXmlUtils.assertTrue((boolean)ConfigXmlUtils.removeElement(removeElement));
        TestConfigXmlUtils.assertEquals((int)1, (int)root.content().size());
        TestConfigXmlUtils.assertEquals((Object)newFirst, root.content().get(0));
        removeElement = root.addElement("removeMeAlso");
        TestConfigXmlUtils.assertTrue((boolean)ConfigXmlUtils.removeElement(removeElement));
        TestConfigXmlUtils.assertEquals((int)1, (int)root.content().size());
        TestConfigXmlUtils.assertEquals((Object)newFirst, root.content().get(0));
    }

    public void testRemoveElementRoot() throws Exception {
        TestConfigXmlUtils.assertFalse((boolean)ConfigXmlUtils.removeElement((Element)new DOMElement("bad")));
    }

    public void testRemoveElementWithSpace() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        root.addText("       ");
        Element removeElement = root.addElement("removeMe");
        Element newFirst = root.addElement("newFirst");
        TestConfigXmlUtils.assertTrue((boolean)ConfigXmlUtils.removeElement(removeElement));
        TestConfigXmlUtils.assertEquals((int)1, (int)root.content().size());
        TestConfigXmlUtils.assertEquals((Object)newFirst, root.content().get(0));
        Element notWhiteSpace = root.addElement("notwhiteSpace");
        removeElement = root.addElement("removeMeAlso");
        TestConfigXmlUtils.assertTrue((boolean)ConfigXmlUtils.removeElement(removeElement));
        TestConfigXmlUtils.assertEquals((int)2, (int)root.content().size());
        TestConfigXmlUtils.assertEquals((Object)newFirst, root.content().get(0));
        TestConfigXmlUtils.assertEquals((Object)notWhiteSpace, root.content().get(1));
    }
}

