/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigPropertySetEntry;
import java.math.BigInteger;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestConfigPropertySetEntry
extends TestCase {
    public void testStringEntry() throws Exception {
        this.checkString(new EntryFactory<String>(){

            @Override
            public ConfigPropertySetEntry create(String name, String value) {
                return ConfigPropertySetEntry.createStringEntry(name, value);
            }
        }, ConfigPropertySetEntry.Type.STRING);
    }

    public void testTextEntry() throws Exception {
        this.checkString(new EntryFactory<String>(){

            @Override
            public ConfigPropertySetEntry create(String name, String value) {
                return ConfigPropertySetEntry.createTextEntry(name, value);
            }
        }, ConfigPropertySetEntry.Type.TEXT);
    }

    public void testIntegerEntry() throws Exception {
        String name = "name";
        Integer value = null;
        ConfigPropertySetEntry entry = ConfigPropertySetEntry.createIntegerEntry("name", value);
        this.assertIntegerEntry(entry, "name", value);
        value = 10;
        entry = ConfigPropertySetEntry.createIntegerEntry("name", value);
        this.assertIntegerEntry(entry, "name", value);
        value = 0;
        entry = ConfigPropertySetEntry.createIntegerEntry("name", value);
        this.assertIntegerEntry(entry, "name", value);
        value = Integer.MAX_VALUE;
        entry = ConfigPropertySetEntry.createIntegerEntry("name", value);
        this.assertIntegerEntry(entry, "name", value);
        value = Integer.MIN_VALUE;
        entry = ConfigPropertySetEntry.createIntegerEntry("name", value);
        this.assertIntegerEntry(entry, "name", value);
    }

    public void testBooleanEntry() throws Exception {
        String name = "name";
        Boolean value = null;
        ConfigPropertySetEntry entry = ConfigPropertySetEntry.createBooleanEntry("name", value);
        this.assertBooleanEntry(entry, "name", value);
        value = Boolean.TRUE;
        entry = ConfigPropertySetEntry.createBooleanEntry("name", value);
        this.assertBooleanEntry(entry, "name", value);
        value = Boolean.FALSE;
        entry = ConfigPropertySetEntry.createBooleanEntry("name", value);
        this.assertBooleanEntry(entry, "name", value);
    }

    public void testLongEntry() throws Exception {
        String name = "name";
        Long value = null;
        ConfigPropertySetEntry entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = 10L;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = 0L;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = Integer.MAX_VALUE;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = 0x80000000L;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = -2147483649L;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = Long.MAX_VALUE;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
        value = Long.MIN_VALUE;
        entry = ConfigPropertySetEntry.createLongEntry("name", value);
        this.assertLongEntry(entry, "name", value);
    }

    public void testGetTypeFromInt() throws Exception {
        TestConfigPropertySetEntry.assertEquals((Object)((Object)ConfigPropertySetEntry.Type.STRING), (Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(5)));
        TestConfigPropertySetEntry.assertEquals((Object)((Object)ConfigPropertySetEntry.Type.TEXT), (Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(6)));
        TestConfigPropertySetEntry.assertEquals((Object)((Object)ConfigPropertySetEntry.Type.INTEGER), (Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(2)));
        TestConfigPropertySetEntry.assertEquals((Object)((Object)ConfigPropertySetEntry.Type.LONG), (Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(3)));
        TestConfigPropertySetEntry.assertEquals((Object)((Object)ConfigPropertySetEntry.Type.BOOLEAN), (Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(1)));
        TestConfigPropertySetEntry.assertNull((Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(0)));
        TestConfigPropertySetEntry.assertNull((Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(-1)));
        TestConfigPropertySetEntry.assertNull((Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(-7)));
        TestConfigPropertySetEntry.assertNull((Object)((Object)ConfigPropertySetEntry.Type.forPropertySetType(7)));
    }

    private void checkString(EntryFactory<String> factory, ConfigPropertySetEntry.Type type) {
        String name = "name";
        String value = "value";
        ConfigPropertySetEntry entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = null;
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = "0";
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = "1";
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(Integer.MAX_VALUE);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(Integer.MIN_VALUE);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(0x80000000L);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(-2147483649L);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(Long.MAX_VALUE);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        value = String.valueOf(Long.MIN_VALUE);
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        BigInteger bigInt = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
        value = bigInt.toString();
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
        bigInt = BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE);
        value = bigInt.toString();
        entry = factory.create("name", value);
        this.assertStringEntry(entry, "name", value, type);
    }

    private void assertStringEntry(ConfigPropertySetEntry entry, String name, String textVal, ConfigPropertySetEntry.Type type) {
        this.assertEntry(entry, name, textVal, TestConfigPropertySetEntry.parseBoolean(textVal), TestConfigPropertySetEntry.parseLong(textVal), TestConfigPropertySetEntry.parseInt(textVal), textVal, type);
    }

    private void assertIntegerEntry(ConfigPropertySetEntry entry, String name, Integer intVal) {
        Long longVal;
        String strVal;
        Boolean boolVal;
        if (intVal != null) {
            boolVal = intVal != 0;
            strVal = intVal.toString();
            longVal = intVal.longValue();
        } else {
            boolVal = false;
            strVal = null;
            longVal = null;
        }
        this.assertEntry(entry, name, strVal, boolVal, longVal, intVal, intVal, ConfigPropertySetEntry.Type.INTEGER);
    }

    private void assertLongEntry(ConfigPropertySetEntry entry, String name, Long longVal) {
        Integer intVal;
        String strVal;
        Boolean boolVal;
        if (longVal != null) {
            boolVal = longVal != 0L;
            strVal = longVal.toString();
            int tmpVal = longVal.intValue();
            intVal = (long)tmpVal == longVal ? Integer.valueOf(tmpVal) : null;
        } else {
            boolVal = false;
            strVal = null;
            intVal = null;
        }
        this.assertEntry(entry, name, strVal, boolVal, longVal, intVal, longVal, ConfigPropertySetEntry.Type.LONG);
    }

    private void assertBooleanEntry(ConfigPropertySetEntry entry, String name, Boolean boolVal) {
        Integer intVal;
        Long longVal;
        String strVal;
        if (boolVal != null) {
            strVal = boolVal.toString();
            longVal = boolVal != false ? 1L : 0L;
            intVal = boolVal != false ? 1 : 0;
        } else {
            longVal = null;
            strVal = null;
            intVal = null;
        }
        this.assertEntry(entry, name, strVal, boolVal, longVal, intVal, boolVal, ConfigPropertySetEntry.Type.BOOLEAN);
    }

    private void assertEntry(ConfigPropertySetEntry entry, String name, String textVal, Boolean boolVal, Long longValue, Integer intVal, Object objVal, ConfigPropertySetEntry.Type type) {
        TestConfigPropertySetEntry.assertEquals((Object)((Object)type), (Object)((Object)entry.getPropertyType()));
        TestConfigPropertySetEntry.assertEquals((String)name, (String)entry.getPropertyName());
        TestConfigPropertySetEntry.assertEquals((String)textVal, (String)entry.asString());
        TestConfigPropertySetEntry.assertEquals((Object)intVal, (Object)entry.asInteger());
        TestConfigPropertySetEntry.assertEquals((Object)longValue, (Object)entry.asLong());
        TestConfigPropertySetEntry.assertEquals((Object)objVal, (Object)entry.asObject());
        TestConfigPropertySetEntry.assertEquals((Object)boolVal, (Object)entry.asBoolean());
    }

    private static Boolean parseBoolean(String stringValue) {
        Integer integer = TestConfigPropertySetEntry.parseInt(stringValue);
        return integer != null && integer != 0;
    }

    private static Long parseLong(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer parseInt(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntryFactory<T> {
        public ConfigPropertySetEntry create(String var1, T var2);
    }
}

