/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import java.math.BigInteger;
import java.util.Collections;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestConfigPropertySet
extends TestCase {
    public void testCotr() throws Exception {
        ConfigPropertySet set = new ConfigPropertySet("name", 7L);
        TestConfigPropertySet.assertEquals((String)"name", (String)set.getEntityName());
        TestConfigPropertySet.assertEquals((long)7L, (long)set.getEntityId());
        TestConfigPropertySet.assertEquals(Collections.emptyMap(), set.entryMap());
        set = new ConfigPropertySet();
        TestConfigPropertySet.assertNull((Object)set.getEntityName());
        TestConfigPropertySet.assertNull((Object)set.getEntityId());
        TestConfigPropertySet.assertEquals(Collections.emptyMap(), set.entryMap());
    }

    public void testStringProperty() throws Exception {
        this.checkTextProperty(new PropertySetter<String>(){

            @Override
            public boolean set(ConfigPropertySet s, String name, String value) {
                return s.setStringProperty(name, value);
            }
        });
    }

    public void testTextProperty() throws Exception {
        this.checkTextProperty(new PropertySetter<String>(){

            @Override
            public boolean set(ConfigPropertySet s, String name, String value) {
                return s.setTextProperty(name, value);
            }
        });
    }

    public void testIntegerProperty() throws Exception {
        String propertyName = "test";
        Integer value = null;
        ConfigPropertySet set = new ConfigPropertySet("name", 7L);
        TestConfigPropertySet.assertFalse((boolean)set.setIntegerProperty("test", value));
        this.assertPropertyDoesNotExist(set, "test");
        value = 1;
        TestConfigPropertySet.assertFalse((boolean)set.setIntegerProperty("test", value));
        this.assertInteger(set, "test", value);
        value = 0;
        TestConfigPropertySet.assertTrue((boolean)set.setIntegerProperty("test", value));
        this.assertInteger(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.removeProperty("test"));
        this.assertPropertyDoesNotExist(set, "test");
        TestConfigPropertySet.assertFalse((boolean)set.removeProperty("test"));
        value = Integer.MAX_VALUE;
        TestConfigPropertySet.assertFalse((boolean)set.setIntegerProperty("test", value));
        this.assertInteger(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.setIntegerProperty("test", null));
        this.assertPropertyDoesNotExist(set, "test");
        TestConfigPropertySet.assertFalse((boolean)set.setIntegerProperty("test", null));
        value = Integer.MIN_VALUE;
        TestConfigPropertySet.assertFalse((boolean)set.setIntegerProperty("test", value));
        this.assertInteger(set, "test", value);
    }

    public void testLongProperty() throws Exception {
        String propertyName = "test";
        Long value = null;
        ConfigPropertySet set = new ConfigPropertySet("name", 7L);
        TestConfigPropertySet.assertFalse((boolean)set.setLongProperty("test", value));
        this.assertPropertyDoesNotExist(set, "test");
        value = 1L;
        TestConfigPropertySet.assertFalse((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        value = 0L;
        TestConfigPropertySet.assertTrue((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.removeProperty("test"));
        this.assertPropertyDoesNotExist(set, "test");
        TestConfigPropertySet.assertFalse((boolean)set.removeProperty("test"));
        value = Integer.MAX_VALUE;
        TestConfigPropertySet.assertFalse((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        value = 0x80000000L;
        TestConfigPropertySet.assertTrue((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.setLongProperty("test", null));
        this.assertPropertyDoesNotExist(set, "test");
        TestConfigPropertySet.assertFalse((boolean)set.setLongProperty("test", null));
        value = -2147483649L;
        TestConfigPropertySet.assertFalse((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        value = Long.MAX_VALUE;
        TestConfigPropertySet.assertTrue((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
        value = Long.MIN_VALUE;
        TestConfigPropertySet.assertTrue((boolean)set.setLongProperty("test", value));
        this.assertLong(set, "test", value);
    }

    public void testBooleanProperty() throws Exception {
        String propertyName = "test";
        Boolean value = null;
        ConfigPropertySet set = new ConfigPropertySet("name", 7L);
        TestConfigPropertySet.assertFalse((boolean)set.setBooleanProperty("test", value));
        this.assertPropertyDoesNotExist(set, "test");
        value = true;
        TestConfigPropertySet.assertFalse((boolean)set.setBooleanProperty("test", value));
        this.assertBoolean(set, "test", value);
        value = true;
        TestConfigPropertySet.assertTrue((boolean)set.setBooleanProperty("test", value));
        this.assertBoolean(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.removeProperty("test"));
        this.assertPropertyDoesNotExist(set, "test");
        TestConfigPropertySet.assertFalse((boolean)set.removeProperty("test"));
        value = true;
        TestConfigPropertySet.assertFalse((boolean)set.setBooleanProperty("test", value));
        this.assertBoolean(set, "test", value);
        value = null;
        TestConfigPropertySet.assertTrue((boolean)set.setBooleanProperty("test", value));
        this.assertPropertyDoesNotExist(set, "test");
    }

    private void checkTextProperty(PropertySetter<String> setter) {
        String propertyName = "test";
        String value = null;
        ConfigPropertySet set = new ConfigPropertySet("name", 7L);
        TestConfigPropertySet.assertFalse((boolean)setter.set(set, "test", value));
        this.assertPropertyDoesNotExist(set, "test");
        value = "value";
        TestConfigPropertySet.assertFalse((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = "true";
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)set.removeProperty("test"));
        TestConfigPropertySet.assertFalse((boolean)set.removeProperty("test"));
        value = "1";
        TestConfigPropertySet.assertFalse((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = "0";
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = String.valueOf(Integer.MAX_VALUE);
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = String.valueOf(Integer.MIN_VALUE);
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = String.valueOf(0x80000000L);
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        value = String.valueOf(-2147483649L);
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        BigInteger integer = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
        value = integer.toString();
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        integer = BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE);
        value = integer.toString();
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", value));
        this.assertText(set, "test", value);
        TestConfigPropertySet.assertTrue((boolean)setter.set(set, "test", null));
        TestConfigPropertySet.assertFalse((boolean)setter.set(set, "test", null));
        this.assertPropertyDoesNotExist(set, "test");
    }

    private void assertBoolean(ConfigPropertySet set, String propertyName, Boolean boolValue) {
        Long longValue;
        Integer intValue;
        String strValue;
        if (boolValue != null) {
            strValue = boolValue.toString();
            intValue = boolValue != false ? 1 : 0;
            longValue = boolValue != false ? 1L : 0L;
        } else {
            strValue = null;
            intValue = null;
            longValue = null;
        }
        this.assertProperty(set, propertyName, strValue, boolValue, longValue, intValue, boolValue);
    }

    private void assertInteger(ConfigPropertySet set, String propertyName, Integer intValue) {
        Long longValue;
        Boolean boolValue;
        String strValue;
        if (intValue != null) {
            strValue = intValue.toString();
            boolValue = intValue != 0;
            longValue = intValue.longValue();
        } else {
            strValue = null;
            boolValue = null;
            longValue = null;
        }
        this.assertProperty(set, propertyName, strValue, boolValue, longValue, intValue, intValue);
    }

    private void assertLong(ConfigPropertySet set, String propertyName, Long longValue) {
        Integer intValue;
        Boolean boolValue;
        String strValue;
        if (longValue != null) {
            int tmpInt = longValue.intValue();
            strValue = longValue.toString();
            boolValue = longValue != 0L;
            intValue = longValue != (long)tmpInt ? null : Integer.valueOf(tmpInt);
        } else {
            strValue = null;
            boolValue = null;
            intValue = null;
        }
        this.assertProperty(set, propertyName, strValue, boolValue, longValue, intValue, longValue);
    }

    private void assertText(ConfigPropertySet set, String propertyName, String stringValue) {
        this.assertProperty(set, propertyName, stringValue, TestConfigPropertySet.parseBoolean(stringValue), TestConfigPropertySet.parseLong(stringValue), TestConfigPropertySet.parseInt(stringValue), stringValue);
    }

    private void assertProperty(ConfigPropertySet set, String propertyName, String stringValue, Boolean boolValue, Long longValue, Integer intValue, Object objValue) {
        TestConfigPropertySet.assertTrue((boolean)set.contains(propertyName));
        TestConfigPropertySet.assertEquals((String)stringValue, (String)set.getStringProperty(propertyName));
        TestConfigPropertySet.assertEquals((String)stringValue, (String)set.getTextProperty(propertyName));
        TestConfigPropertySet.assertEquals((Object)boolValue, (Object)set.getBooleanProperty(propertyName));
        TestConfigPropertySet.assertEquals((Object)intValue, (Object)set.getIntegerProperty(propertyName));
        TestConfigPropertySet.assertEquals((Object)longValue, (Object)set.getLongProperty(propertyName));
        TestConfigPropertySet.assertEquals((Object)objValue, (Object)set.getObjectProperty(propertyName));
    }

    private static Boolean parseBoolean(String stringValue) {
        Integer integer = TestConfigPropertySet.parseInt(stringValue);
        return integer != null && integer != 0;
    }

    private static Long parseLong(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer parseInt(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void assertPropertyDoesNotExist(ConfigPropertySet set, String propertyName) {
        TestConfigPropertySet.assertFalse((boolean)set.contains(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getStringProperty(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getTextProperty(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getBooleanProperty(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getIntegerProperty(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getObjectProperty(propertyName));
        TestConfigPropertySet.assertNull((Object)set.getLongProperty(propertyName));
        TestConfigPropertySet.assertEquals((String)"default", (String)set.getStringPropertyDefault(propertyName, "default"));
        TestConfigPropertySet.assertTrue((boolean)set.getBooleanPropertyDefault(propertyName, true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PropertySetter<T> {
        public boolean set(ConfigPropertySet var1, String var2, T var3);
    }
}

