/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import junit.framework.TestCase;

public class TestConfigMailServer
extends TestCase {
    public void testType() throws Exception {
        TestConfigMailServer.assertNull((Object)((Object)ConfigMailServer.Type.parseString(null)));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.POP), (Object)((Object)ConfigMailServer.Type.parseString("pOP")));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.POP), (Object)((Object)ConfigMailServer.Type.parseString("POP")));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.POP), (Object)((Object)ConfigMailServer.Type.parseString("pop")));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.SMTP), (Object)((Object)ConfigMailServer.Type.parseString("SmTP")));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.SMTP), (Object)((Object)ConfigMailServer.Type.parseString("SMTP")));
        TestConfigMailServer.assertSame((Object)((Object)ConfigMailServer.Type.SMTP), (Object)((Object)ConfigMailServer.Type.parseString("smtp")));
        TestConfigMailServer.assertNull((Object)((Object)ConfigMailServer.Type.parseString("someRandomType")));
    }

    public void testMailServers() throws Exception {
        ConfigMailServer mailServer = new ConfigMailServer().setId(10L).setName("name").setDescription("desc").setFrom("jack@jill.com");
        mailServer.setPrefix("PREFIX").setPort(10).setType(ConfigMailServer.Type.SMTP).setServerName("localhost").setJndiLocation("location");
        mailServer.setUserName("bbain").setPassword("password");
        TestConfigMailServer.assertEquals((long)10L, (long)mailServer.getId());
        TestConfigMailServer.assertEquals((String)"name", (String)mailServer.getName());
        TestConfigMailServer.assertEquals((String)"desc", (String)mailServer.getDescription());
        TestConfigMailServer.assertEquals((String)"jack@jill.com", (String)mailServer.getFrom());
        TestConfigMailServer.assertEquals((String)"PREFIX", (String)mailServer.getPrefix());
        TestConfigMailServer.assertEquals((int)10, (int)mailServer.getPortNumber());
        TestConfigMailServer.assertEquals((Object)((Object)ConfigMailServer.Type.SMTP), (Object)((Object)mailServer.getType()));
        TestConfigMailServer.assertEquals((String)"localhost", (String)mailServer.getServerName());
        TestConfigMailServer.assertEquals((String)"location", (String)mailServer.getJndiLocation());
        TestConfigMailServer.assertEquals((String)"bbain", (String)mailServer.getUserName());
        TestConfigMailServer.assertEquals((String)"password", (String)mailServer.getPassword());
        mailServer.setPort("abc");
        TestConfigMailServer.assertEquals((String)"abc", (String)mailServer.getPort());
        TestConfigMailServer.assertNull((Object)mailServer.getPortNumber());
        mailServer.setType("skss");
        TestConfigMailServer.assertNull((Object)((Object)mailServer.getType()));
        mailServer.setType("pOP");
        TestConfigMailServer.assertEquals((Object)((Object)ConfigMailServer.Type.POP), (Object)((Object)mailServer.getType()));
    }
}

