/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigFixerUpperer;
import com.atlassian.jira.functest.unittests.config.ConfigurationDefaults;
import com.atlassian.jira.functest.unittests.config.ZipHelper;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.dom4j.util.NodeComparator;

public class TestConfigFixerUpperer
extends TestCase
implements EnvironmentAware {
    private File root;

    protected void tearDown() throws Exception {
        this.root = null;
    }

    public void testFixBrokenFiles() throws Exception {
        File directory = TempDirectoryUtil.createTempDirectory("testFixBrokenFiles");
        ZipHelper.extractTo(this.getFile("fixerBroken.zip"), directory);
        ConfigFixerUpperer upper = new ConfigFixerUpperer();
        upper.setRoot(directory).setConfigurationChecks(ConfigurationDefaults.createDefaultConfigurationChecks());
        upper.setBackup(true);
        upper.setExcludes(Collections.singletonList(new NameFileFilter("empty.xml")));
        upper.fix();
        this.checkResult(directory);
        FileUtils.deleteDirectory((File)directory);
    }

    private void checkResult(File file) throws Exception {
        IOFileFilter tempFiler = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".xml"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".zip"));
        tempFiler = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)tempFiler));
        this.visitFiles(file, tempFiler, new FileVisitor(){

            public void visitFile(File file) throws Exception {
                TestConfigFixerUpperer.this.checkFile(file);
            }
        });
    }

    private void visitFiles(File file, IOFileFilter tmpFilter, FileVisitor visitor) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles((FileFilter)tmpFilter)) {
                this.visitFiles(f, tmpFilter, visitor);
            }
        } else {
            visitor.visitFile(file);
        }
    }

    private void checkFile(File file) throws Exception {
        File origFile = this.addExtension(file, "orig");
        File fixFile = this.addExtension(file, "fix");
        File backupFile = this.addExtension(file, "bak");
        if (fixFile.exists()) {
            TestConfigFixerUpperer.assertTrue((String)("Did not seem to backup: '" + file + "'."), (boolean)backupFile.exists());
            TestConfigFixerUpperer.assertTrue((String)String.format("Backup file '%s' does not match '%s'.", backupFile, origFile), (boolean)FileUtils.contentEquals((File)backupFile, (File)origFile));
            this.assertXmlDom(fixFile, file);
        } else {
            TestConfigFixerUpperer.assertFalse((String)("Did backup of '" + file + "' when not expected."), (boolean)backupFile.exists());
            TestConfigFixerUpperer.assertTrue((String)String.format("File '%s' should not be changed.", file), (boolean)FileUtils.contentEquals((File)file, (File)origFile));
        }
    }

    private void assertXmlDom(File expected, File actual) throws Exception {
        Document expectedDoc = this.readFile(expected);
        Document actualDoc = this.readFile(actual);
        NodeComparator comparator = new NodeComparator();
        TestConfigFixerUpperer.assertTrue((String)String.format("Expected file '%s' did not match actual file '%s'.", expected, actual), (comparator.compare(expectedDoc, actualDoc) == 0 ? 1 : 0) != 0);
    }

    private Document readFile(File file) throws Exception {
        String extension = FilenameUtils.getExtension((String)StringUtils.removeEnd((String)file.getName(), (String)".fix"));
        if ("XML".equalsIgnoreCase(extension)) {
            return this.readRaw(file);
        }
        if ("ZIP".equalsIgnoreCase(extension)) {
            return this.readZip(file);
        }
        throw new IOException("Don't know how to process '" + file + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readRaw(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            Document document = this.readFromStream(fis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readZip(File file) throws Exception {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        try {
            zis.getNextEntry();
            Document document = this.readFromStream(zis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private Document readFromStream(InputStream stream) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(true);
        return reader.read(stream);
    }

    private File addExtension(File file, String extension) {
        return new File(file.getParent(), file.getName() + '.' + extension);
    }

    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.setRoot(this.root);
    }

    private void setRoot(File root) {
        if (root != null) {
            this.root = root = this.normalizeFile(root);
        }
    }

    private File getRoot() {
        if (this.root == null) {
            File root = new LocalTestEnvironmentData().getXMLDataLocation();
            if (root == null) {
                throw new RuntimeException("Unable to find XML location. Make sure your environment is setup.");
            }
            this.root = this.normalizeFile(root);
        }
        return this.root;
    }

    private File normalizeFile(File root) {
        try {
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            root = root.getAbsoluteFile();
        }
        return root;
    }

    private File getFile(String child) {
        return new File(this.getRoot(), child);
    }

    private void main() throws Exception {
        File directory = TempDirectoryUtil.createTempDirectory("makeZip");
        ZipHelper.extractTo(this.getFile("fixerBroken.zip"), directory);
        IOFileFilter tmpFilter = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".orig"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".fix"));
        tmpFilter = FileFilterUtils.makeFileOnly((IOFileFilter)tmpFilter);
        tmpFilter = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)tmpFilter);
        this.visitFiles(directory, tmpFilter, new FileVisitor(){

            public void visitFile(File file) throws Exception {
                if (!file.delete()) {
                    throw new IOException("Unable to delete '" + file + "'.");
                }
            }
        });
        this.visitFiles(directory, FileFilterUtils.trueFileFilter(), new FileVisitor(){

            public void visitFile(File file) throws Exception {
                FileUtils.copyFile((File)file, (File)TestConfigFixerUpperer.this.addExtension(file, "orig"));
            }
        });
        ConfigFixerUpperer upper = new ConfigFixerUpperer();
        upper.setRoot(directory).setConfigurationChecks(ConfigurationDefaults.createDefaultConfigurationChecks());
        upper.setBackup(true);
        upper.fix();
        tmpFilter = FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".bak"));
        tmpFilter = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)tmpFilter);
        this.visitFiles(directory, tmpFilter, new FileVisitor(){

            public void visitFile(File backFile) throws Exception {
                File sourceFile = new File(backFile.getParent(), FilenameUtils.getBaseName((String)backFile.getName()));
                File fixFile = TestConfigFixerUpperer.this.addExtension(sourceFile, "fix");
                FileUtils.moveFile((File)sourceFile, (File)fixFile);
                FileUtils.moveFile((File)backFile, (File)sourceFile);
            }
        });
        System.out.printf("The directory '%s' has been created with the test content. Check the directory to make sure it is correct.", directory);
    }

    public static void main(String[] args) throws Exception {
        new TestConfigFixerUpperer().main();
    }

    private static interface FileVisitor {
        public void visitFile(File var1) throws Exception;
    }
}

