/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigFile;
import com.atlassian.jira.functest.unittests.config.ConfigFileWalker;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestConfigFileWalker
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWalk() throws Exception {
        File root = this.normalizeFile(TempDirectoryUtil.createTempDirectory("testWalker"));
        root.deleteOnExit();
        try {
            File dir1 = this.createSubDirectory(root, "dir1");
            File svn = this.createSubDirectory(root, ".svn");
            File one = this.createFile(root, "one.xml");
            File two = this.createFile(dir1, "two.zip");
            this.createFile(root, "ignoe.doc");
            this.createFile(svn, "ignoreme.xml");
            File explicit = this.createFile(dir1, "explicit.xml");
            RecordingConfigWalker visitor = new RecordingConfigWalker();
            ConfigFileWalker walker = new ConfigFileWalker(root, visitor);
            walker.walk();
            TestConfigFileWalker.assertEquals(this.asSet(one, two, explicit), (Object)visitor.files);
            TestConfigFileWalker.assertEquals(Collections.emptySet(), (Object)visitor.errors);
            walker.addFileNameExclude("explicit.xml");
            visitor.reset();
            walker.walk();
            TestConfigFileWalker.assertEquals(this.asSet(one, two), (Object)visitor.files);
            TestConfigFileWalker.assertEquals(Collections.emptySet(), (Object)visitor.errors);
        }
        finally {
            FileUtils.deleteQuietly((File)root);
        }
    }

    private File createSubDirectory(File root, String name) {
        File subDir = this.normalizeFile(new File(root, name));
        TestConfigFileWalker.assertTrue((boolean)subDir.mkdirs());
        return subDir;
    }

    private File createFile(File root, String name) throws IOException {
        File newFile = this.normalizeFile(new File(root, name));
        TestConfigFileWalker.assertTrue((boolean)newFile.createNewFile());
        return newFile;
    }

    private File normalizeFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private <T> Set<T> asSet(T ... elems) {
        return new HashSet<T>(Arrays.asList(elems));
    }

    private static class RecordingConfigWalker
    implements ConfigFileWalker.ConfigVisitor {
        private Set<File> errors = new HashSet<File>();
        private Set<File> files = new HashSet<File>();

        private RecordingConfigWalker() {
        }

        public void visitConfig(ConfigFile file) {
            this.files.add(file.getFile());
        }

        public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
            this.errors.add(file);
        }

        private void reset() {
            this.files.clear();
            this.errors.clear();
        }
    }
}

