/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckMessage;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestCheckResultBuilder
extends TestCase {
    public void testBuilder() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        CheckResultBuilder.Result result = builder.buildResult();
        ArrayList<CheckMessage> errors = new ArrayList<CheckMessage>();
        ArrayList<CheckMessage> warnings = new ArrayList<CheckMessage>();
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertTrue((boolean)result.isGood());
        result = builder.error("jack").buildResult();
        errors.add(new CheckMessage("jack", null));
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertFalse((boolean)result.isGood());
        result = builder.error("jill", "jack").buildResult();
        errors.add(new CheckMessage("jill", "jack"));
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertFalse((boolean)result.isGood());
        result = builder.warning("abc").buildResult();
        warnings.add(new CheckMessage("abc"));
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertFalse((boolean)result.isGood());
        result = builder.warning("fgh", "def").buildResult();
        warnings.add(new CheckMessage("fgh", "def"));
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertFalse((boolean)result.isGood());
        builder = new CheckResultBuilder();
        errors.clear();
        warnings.clear();
        result = builder.warning("onlywarning").buildResult();
        warnings.add(new CheckMessage("onlywarning"));
        TestCheckResultBuilder.assertEquals(errors, result.getErrors());
        TestCheckResultBuilder.assertEquals(warnings, result.getWarnings());
        TestCheckResultBuilder.assertFalse((boolean)result.isGood());
    }
}

