/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptions;
import com.atlassian.jira.functest.unittests.config.CheckOptionsFactory;
import java.util.Locale;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;

public class TestCheckOptionsFactory
extends TestCase {
    public void testAllOptions() throws Exception {
        CheckOptions checkOptions = CheckOptionsFactory.allOptions();
        for (String id : new String[]{"I", "really", "dont", "care", "what", "this", "is", null}) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(id));
        }
    }

    public void testNoOptions() throws Exception {
        CheckOptions checkOptions = CheckOptionsFactory.noOptions();
        for (String id : new String[]{"I", "really", "dont", "care", "what", "this", "is", null}) {
            TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(id));
        }
    }

    public void testDisabledOptions() throws Exception {
        String[] strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"};
        CheckOptions checkOptions = CheckOptionsFactory.disabled(strings);
        for (String id : strings) {
            TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(id));
            TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(id.toUpperCase(Locale.ENGLISH)));
        }
        TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(null));
        TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(""));
        TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled("OtherWord"));
    }

    public void testDisabledOptionsNone() throws Exception {
        String[] strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"};
        CheckOptions checkOptions = CheckOptionsFactory.disabled(new String[0]);
        for (String id : strings) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(id));
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(id.toUpperCase(Locale.ENGLISH)));
        }
    }

    public void testFromDocumentNoSuppress() throws Exception {
        String[] strings;
        Document document = this.createWithComments("test", new String[0]);
        CheckOptions checkOptions = CheckOptionsFactory.parseOptions(document);
        for (String string : strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"}) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(string));
        }
    }

    public void testFromDocumentSuppressOne() throws Exception {
        String[] strings;
        Document document = this.createWithComments("test", "blarg\nsuppresschecks: me                  \ndag");
        CheckOptions checkOptions = CheckOptionsFactory.parseOptions(document);
        for (String string : strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"}) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(string));
        }
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" me    "));
    }

    public void testFromDocumentSuppressMany() throws Exception {
        String[] strings;
        Document document = this.createWithComments("test", "blarg\nsuppresschecks: me    , other              \ndag");
        CheckOptions checkOptions = CheckOptionsFactory.parseOptions(document);
        for (String string : strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"}) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(string));
        }
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" me    "));
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" other    "));
    }

    public void testFromDocumentSuppressManyMultipleComments() throws Exception {
        String[] strings;
        Document document = this.createWithComments("test", "blarg\n     suppresschecks: me    , other              \ndag\n   suppresscheck bbb", "suppresschecks:aaa");
        CheckOptions checkOptions = CheckOptionsFactory.parseOptions(document);
        for (String string : strings = new String[]{"I", "really", "dont", "care", "what", "this", "is"}) {
            TestCheckOptionsFactory.assertTrue((boolean)checkOptions.checkEnabled(string));
        }
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" me    "));
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" other    "));
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" aaa    "));
        TestCheckOptionsFactory.assertFalse((boolean)checkOptions.checkEnabled(" bbb    "));
    }

    public void testFromDocumentSuppressAll() throws Exception {
        String[] strings;
        Document document = this.createWithComments("test", "blarg\n     suppresschecks: me    , other              \ndag", "suppresschecks:aaa", "suppresscheck AlL");
        CheckOptions checkOptions = CheckOptionsFactory.parseOptions(document);
        for (String string : strings = new String[]{"I", "really", "dont", "care", "what", "this", "is", "me", "other", "aaa"}) {
            TestCheckOptionsFactory.assertFalse((String)string, (boolean)checkOptions.checkEnabled(string));
        }
    }

    private Document createWithComments(String element, String ... comments) {
        DocumentFactory instance = DocumentFactory.getInstance();
        Document document = instance.createDocument();
        document.addElement(element);
        for (String comment : comments) {
            document.addComment(comment);
        }
        return document;
    }
}

