/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;

public class ConfigXmlUtils {
    private ConfigXmlUtils() {
    }

    public static Element createNewElement(Element parent, String elementName) {
        List list = parent.content();
        int lastPos = -1;
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Node current = (Node)it.next();
            if (!(current instanceof Element) || !current.getName().equals(elementName)) continue;
            lastPos = it.previousIndex();
        }
        DocumentFactory factory = DocumentFactory.getInstance();
        list.add(lastPos + 1, factory.createText("\n    "));
        Element element = factory.createElement(elementName);
        list.add(lastPos + 2, element);
        return element;
    }

    public static void setAttribute(Element element, String attributeName, String attributeValue) {
        boolean shouldElement;
        if (attributeValue == null) {
            ConfigXmlUtils.removeAttribute(element, attributeName);
            return;
        }
        boolean bl = shouldElement = attributeValue.indexOf(10) >= 0 || attributeValue.indexOf(13) >= 0;
        if (shouldElement) {
            Element sub;
            Attribute attrib = element.attribute(attributeName);
            if (attrib != null) {
                element.remove(attrib);
            }
            if ((sub = element.element(attributeName)) == null) {
                sub = element.addElement(attributeName);
            }
            sub.setText(attributeValue);
        } else {
            Attribute attribute;
            Element sub = element.element(attributeName);
            if (sub != null) {
                element.remove(sub);
            }
            if ((attribute = element.attribute(attributeName)) == null) {
                element.addAttribute(attributeName, attributeValue);
            } else {
                attribute.setValue(attributeValue);
            }
        }
    }

    public static void removeAttribute(Element element, String attributeName) {
        Element sub;
        Attribute attrib = element.attribute(attributeName);
        if (attrib != null) {
            element.remove(attrib);
        }
        if ((sub = element.element(attributeName)) != null) {
            element.remove(sub);
        }
    }

    public static String getTextValue(Element element, String attribute) {
        String attribValue = element.attributeValue(attribute);
        if (attribValue != null) {
            return attribValue;
        }
        Element valueElement = element.element(attribute);
        if (valueElement != null) {
            return valueElement.getText();
        }
        return null;
    }

    public static Long getLongValue(Element element, String attribute) {
        String text = ConfigXmlUtils.getTextValue(element, attribute);
        if (text != null) {
            try {
                return new Long(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Integer getIntegerValue(Element element, String attribute) {
        String text = ConfigXmlUtils.getTextValue(element, attribute);
        if (text != null) {
            try {
                return new Integer(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean removeElement(Element element) {
        Element parent = element.getParent();
        if (parent == null) {
            return false;
        }
        List list = parent.content();
        int indexOf = list.indexOf(element);
        if (indexOf >= 0) {
            Node textNode;
            if (indexOf > 0 && (textNode = (Node)list.get(indexOf - 1)) instanceof Text && StringUtils.isBlank((String)textNode.getText())) {
                list.remove(--indexOf);
            }
            list.remove(indexOf);
            return true;
        }
        return false;
    }
}

