/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

abstract class ConfigPropertySetEntry {
    private final String propertyName;
    private final Type propertyType;

    ConfigPropertySetEntry(String propertyName, Type propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    Type getPropertyType() {
        return this.propertyType;
    }

    abstract String asString();

    abstract Long asLong();

    abstract Boolean asBoolean();

    abstract Integer asInteger();

    abstract Object asObject();

    static ConfigPropertySetEntry createStringEntry(String name, String value) {
        return new StringEntry(name, Type.STRING, value);
    }

    static ConfigPropertySetEntry createTextEntry(String name, String value) {
        return new StringEntry(name, Type.TEXT, value);
    }

    static ConfigPropertySetEntry createIntegerEntry(String name, Integer value) {
        return new IntegerEntry(name, value);
    }

    static ConfigPropertySetEntry createLongEntry(String name, Long value) {
        return new LongEntry(name, value);
    }

    static ConfigPropertySetEntry createBooleanEntry(String name, Boolean b) {
        return new BooleanEntry(name, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigPropertySetEntry that = (ConfigPropertySetEntry)o;
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        return this.propertyType == that.propertyType;
    }

    public int hashCode() {
        int result = this.propertyName != null ? this.propertyName.hashCode() : 0;
        result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s(%s): %s", this.propertyName, this.propertyType.name(), this.asString());
    }

    private static class BooleanEntry
    extends ConfigPropertySetEntry {
        private final Boolean value;

        private BooleanEntry(String propertyName, Boolean value) {
            super(propertyName, Type.BOOLEAN);
            this.value = value;
        }

        String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        Long asLong() {
            if (this.value != null) {
                return this.value != false ? 1L : 0L;
            }
            return null;
        }

        Boolean asBoolean() {
            return this.value;
        }

        Integer asInteger() {
            if (this.value != null) {
                return this.value != false ? 1 : 0;
            }
            return null;
        }

        Object asObject() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BooleanEntry that = (BooleanEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class LongEntry
    extends ConfigPropertySetEntry {
        private final Long value;

        private LongEntry(String propertyName, Long value) {
            super(propertyName, Type.LONG);
            this.value = value;
        }

        String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        Long asLong() {
            return this.value;
        }

        Boolean asBoolean() {
            return this.value != null && this.value != 0L;
        }

        Integer asInteger() {
            if (this.value != null) {
                int tmpValue = this.value.intValue();
                return (long)tmpValue != this.value ? null : Integer.valueOf(tmpValue);
            }
            return null;
        }

        Object asObject() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LongEntry longEntry = (LongEntry)o;
            return !(this.value != null ? !this.value.equals(longEntry.value) : longEntry.value != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class IntegerEntry
    extends ConfigPropertySetEntry {
        private final Integer value;

        private IntegerEntry(String propertyName, Integer value) {
            super(propertyName, Type.INTEGER);
            this.value = value;
        }

        String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        Long asLong() {
            return this.value != null ? Long.valueOf(this.value.longValue()) : null;
        }

        Boolean asBoolean() {
            return this.value != null && this.value != 0;
        }

        Integer asInteger() {
            return this.value;
        }

        Object asObject() {
            if (this.getPropertyType() == Type.BOOLEAN) {
                return this.asBoolean();
            }
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IntegerEntry that = (IntegerEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class StringEntry
    extends ConfigPropertySetEntry {
        private final String value;

        public StringEntry(String propertyName, Type propertyType, String value) {
            super(propertyName, propertyType);
            this.value = value;
        }

        String asString() {
            return this.value;
        }

        Long asLong() {
            if (this.value != null) {
                try {
                    return new Long(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        Boolean asBoolean() {
            Integer integer = this.asInteger();
            return integer != null && integer != 0;
        }

        Integer asInteger() {
            if (this.value != null) {
                try {
                    return new Integer(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        Object asObject() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StringEntry that = (StringEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        STRING(5),
        TEXT(6),
        INTEGER(2),
        LONG(3),
        BOOLEAN(1);

        private int psType;

        private Type(int psType) {
            this.psType = psType;
        }

        int getPropertySetType() {
            return this.psType;
        }

        static Type forPropertySetType(int psType) {
            for (Type type : Type.values()) {
                if (type.getPropertySetType() != psType) continue;
                return type;
            }
            return null;
        }
    }
}

