/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Comment;
import org.dom4j.Document;

public final class CheckOptionsFactory {
    private static final AllOptions ALL_OPTIONS = new AllOptions();
    private static final NoOptions NO_OPTIONS = new NoOptions();
    private static final String ALL_OPTION = "all";
    private static final Pattern OPTION_PATTEN = Pattern.compile("^\\s*suppresschecks?(?::|\\s)(.+)$", 10);

    private CheckOptionsFactory() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone me, I'm a loner.");
    }

    public static CheckOptions allOptions() {
        return ALL_OPTIONS;
    }

    public static CheckOptions noOptions() {
        return NO_OPTIONS;
    }

    public static CheckOptions disabled(String ... options) {
        return new DisabledOptions(Arrays.asList(options));
    }

    public static CheckOptions parseOptions(Document document) {
        HashSet<String> checkExcludes = new HashSet<String>();
        List list = document.selectNodes("/comment()");
        for (Comment comment : list) {
            String s = comment.getText();
            Matcher matcher = OPTION_PATTEN.matcher(s);
            int pos = 0;
            while (pos < s.length() && matcher.find(pos)) {
                String[] parsedOptions;
                for (String parsedOption : parsedOptions = matcher.group(1).split(Pattern.quote(","))) {
                    if (CheckOptionsFactory.isAllOption(parsedOption = CheckOptionsFactory.normalizeOption(parsedOption))) {
                        return CheckOptionsFactory.noOptions();
                    }
                    checkExcludes.add(parsedOption);
                }
                pos = matcher.end() + 1;
            }
        }
        if (checkExcludes.isEmpty()) {
            return CheckOptionsFactory.allOptions();
        }
        return new DisabledOptions(checkExcludes);
    }

    private static boolean isAllOption(String option) {
        return ALL_OPTION.equalsIgnoreCase(option);
    }

    private static String normalizeOption(String checkId) {
        if ((checkId = StringUtils.trimToNull((String)checkId)) != null) {
            return checkId.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisabledOptions
    implements CheckOptions {
        private final Set<String> disabledOptions;

        public DisabledOptions(Collection<String> disabledOptions) {
            HashSet<String> strings = new HashSet<String>();
            for (String option : disabledOptions) {
                if ((option = CheckOptionsFactory.normalizeOption(option)) == null) continue;
                strings.add(option);
            }
            this.disabledOptions = Collections.unmodifiableSet(strings);
        }

        @Override
        public boolean checkEnabled(String checkId) {
            return !this.disabledOptions.contains(CheckOptionsFactory.normalizeOption(checkId));
        }
    }

    private static class NoOptions
    implements CheckOptions {
        private NoOptions() {
        }

        public boolean checkEnabled(String checkId) {
            return false;
        }
    }

    private static class AllOptions
    implements CheckOptions {
        private AllOptions() {
        }

        public boolean checkEnabled(String checkId) {
            return true;
        }
    }
}

