/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptions;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import java.util.Iterator;

public final class BackupChecker
implements ConfigurationCheck {
    private static final String CHECK_BACKUP_SERVICE = "backupservice";
    private static final String CHECK_BACKUP_SERVICE_HOME = "backupservicehome";
    private static final String CHECK_BACKUP_SERVICE_DIRECTORY = "backupservicedirectory";
    private static final String CHECK_GLOBAL_BACKUP_DIRECTORY = "backupglobaldirectory";
    private static final String OPT_USE_DEFAULT_DIRECTORY = "USE_DEFAULT_DIRECTORY";
    private static final String OPT_DIR_NAME = "DIR_NAME";
    private static final String JIRA_PATH_BACKUP = "jira.path.backup";
    private static final String BACKUP_SERVICE = "ExportService";
    private static final String DEAFULT_BACKUP_PATH = "func_test_backup";

    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        try {
            this.processConfig(config, options, builder);
        }
        catch (Exception e) {
            return builder.error(e.getMessage()).buildResult();
        }
        return builder.buildResult();
    }

    private void processConfig(JiraConfig config, CheckOptions options, CheckResultBuilder builder) {
        ConfigPropertySet configPropertySet;
        String s;
        for (ConfigService service : config.getServices()) {
            ConfigPropertySet propertySet;
            if (service.getClazz() == null || !service.getClazz().contains(BACKUP_SERVICE)) continue;
            if (options.checkEnabled(CHECK_BACKUP_SERVICE)) {
                String name = service.getName() != null ? service.getName() : "<anonymous>";
                builder.error(String.format("Backup service '%s' exists.", name), CHECK_BACKUP_SERVICE);
                continue;
            }
            if (options.checkEnabled(CHECK_BACKUP_SERVICE_HOME) && !Boolean.parseBoolean((propertySet = service.getPropertySet()).getStringProperty(OPT_USE_DEFAULT_DIRECTORY))) {
                String directory = propertySet.getStringPropertyDefault(OPT_DIR_NAME, "<none>");
                builder.error(String.format("Backup service configured to output to directory '%s' it should be using JIRA.HOME.", directory), CHECK_BACKUP_SERVICE_HOME);
            }
            if (!options.checkEnabled(CHECK_BACKUP_SERVICE_DIRECTORY)) continue;
            propertySet = service.getPropertySet();
            String property = propertySet.getStringPropertyDefault(OPT_DIR_NAME, "<none>");
            if (!propertySet.contains(OPT_DIR_NAME) || DEAFULT_BACKUP_PATH.equals(property)) continue;
            builder.warning(String.format("Backup service configured to output to '%s'. It should always be set to '%s' even when using JIRA.HOME.", property, DEAFULT_BACKUP_PATH), CHECK_BACKUP_SERVICE_DIRECTORY);
        }
        if (options.checkEnabled(CHECK_GLOBAL_BACKUP_DIRECTORY) && (s = (configPropertySet = config.getApplicationProperties()).getStringProperty(JIRA_PATH_BACKUP)) != null) {
            builder.warning(String.format("Global backup path set to '%s'.", s), CHECK_GLOBAL_BACKUP_DIRECTORY);
        }
    }

    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        Iterator<ConfigService> iterator = config.getServices().iterator();
        while (iterator.hasNext()) {
            String dirName;
            ConfigService service = iterator.next();
            if (service.getClazz() == null || !service.getClazz().contains(BACKUP_SERVICE)) continue;
            if (options.checkEnabled(CHECK_BACKUP_SERVICE)) {
                iterator.remove();
                continue;
            }
            ConfigPropertySet propertySet = service.getPropertySet();
            if (options.checkEnabled(CHECK_BACKUP_SERVICE_HOME)) {
                propertySet.setStringProperty(OPT_USE_DEFAULT_DIRECTORY, Boolean.toString(true));
            }
            if (!options.checkEnabled(CHECK_BACKUP_SERVICE_DIRECTORY) || (dirName = propertySet.getStringProperty(OPT_DIR_NAME)) == null) continue;
            propertySet.setStringProperty(OPT_DIR_NAME, DEAFULT_BACKUP_PATH);
        }
        ConfigPropertySet configPropertySet = config.getApplicationProperties();
        if (options.checkEnabled(CHECK_GLOBAL_BACKUP_DIRECTORY)) {
            configPropertySet.removeProperty(JIRA_PATH_BACKUP);
        }
    }
}

