/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.TestSuiteBuilder;
import com.atlassian.jira.webtests.AcceptanceTestHarness;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTestSuiteBuilder
extends TestCase {
    protected void tearDown() throws Exception {
        TestEnvAware.callCount = 0;
    }

    public void testCotr() throws Exception {
        try {
            new TestSuiteBuilder(0, 5);
            TestTestSuiteBuilder.fail((String)"Should now allow zero to be set for batch number.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new TestSuiteBuilder(2, 0);
            TestTestSuiteBuilder.fail((String)"Should now allow zero to be set for max batch number.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmpty() {
        TestSuiteBuilder builder = new TestSuiteBuilder();
        Test test = builder.build();
        TestTestSuiteBuilder.assertEquals((int)0, (int)test.countTestCases());
        builder = new TestSuiteBuilder(1, 5);
        test = builder.build();
        TestTestSuiteBuilder.assertEquals((int)0, (int)test.countTestCases());
    }

    public void testNoBatch() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder();
        builder.addTests(Collections.singleton(TestFive.class));
        this.assertTestSuite(builder.build(), TestFive.class);
        this.assertTestSuite(builder.build(), TestFive.class);
        builder.addTest(TestFive.class);
        builder.addTest(TestOne.class);
        this.assertTestSuite(builder.build(), TestFive.class, TestOne.class);
    }

    public void testSingleTestBigBatch() {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 7);
        builder.addTests(Collections.singleton(TestFive.class));
        this.assertTestSuite(builder.build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), new Class[0]);
    }

    public void testSingleTestSmallBatch() {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 2);
        builder.addTests(Collections.singleton(TestFive.class));
        this.assertTestSuite(builder.build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), new Class[0]);
    }

    public void testMultipleTestNoComposite() {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 3);
        builder.addTests(TestTwo.class, TestThree.class, TestOne.class);
        this.assertTestSuite(builder.build(), TestTwo.class);
        this.assertTestSuite(builder.batch(2).build(), TestThree.class);
        this.assertTestSuite(builder.batch(3).build(), TestOne.class);
        builder = new TestSuiteBuilder(1, 3);
        builder.addTests(TestFive.class, TestTwo.class, TestOne.class);
        this.assertTestSuite(builder.batch(1).build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), TestTwo.class);
        this.assertTestSuite(builder.batch(3).build(), TestOne.class);
    }

    public void testMultipleTestsWithCompositeExact() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 2);
        builder.addTests(TestTwo.class, TestThree.class, TestFive.class);
        this.assertTestSuite(builder.build(), TestTwo.class, TestThree.class);
        this.assertTestSuite(builder.batch(2).build(), TestFive.class);
    }

    public void testMultipleTestsWithCompositeWithEmptyBatch() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 3);
        builder.addTests(TestFive.class, TestOne.class);
        this.assertTestSuite(builder.build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), TestOne.class);
        this.assertTestSuite(builder.batch(3).build(), new Class[0]);
        builder.addTest(TestTwo.class);
        this.assertTestSuite(builder.batch(1).build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), TestOne.class, TestTwo.class);
        this.assertTestSuite(builder.batch(3).build(), new Class[0]);
    }

    public void testMultipleTestWithComposite() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 5);
        builder.addTests(TestFive.class, TestOne.class, TestFour.class, TestTwo.class, TestThree.class);
        this.assertTestSuite(builder.build(), TestFive.class);
        this.assertTestSuite(builder.batch(2).build(), TestOne.class, TestFour.class);
        this.assertTestSuite(builder.batch(3).build(), TestTwo.class);
        this.assertTestSuite(builder.batch(4).build(), TestThree.class);
        this.assertTestSuite(builder.batch(5).build(), new Class[0]);
    }

    public void testSingleSplitNoBatches() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder();
        builder.addTest(TestFiveSplit.class);
        this.assertTestSuite(builder.build(), TestFiveSplit.class);
    }

    public void testSingleSplitBatches() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder();
        builder.addTest(TestFiveSplit.class);
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test1", "test2")), builder.maxBatch(3).batch(1).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test3", "test4")), builder.batch(2).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test5")), builder.batch(3).build());
    }

    public void testSingleSplitWithEmptyBatches() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder();
        builder.addTest(TestFiveSplit.class);
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test1")), builder.maxBatch(10).batch(1).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test2")), builder.batch(2).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test3")), builder.batch(3).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test4")), builder.batch(4).build());
        this.assertTestSuite(this.wrapInSuite((Test)this.splitTest(TestFiveSplit.class, "test5")), builder.batch(5).build());
        this.assertTestSuite(new TestSuite(), builder.batch(6).build());
        this.assertTestSuite(new TestSuite(), builder.batch(7).build());
        this.assertTestSuite(new TestSuite(), builder.batch(8).build());
        this.assertTestSuite(new TestSuite(), builder.batch(9).build());
        this.assertTestSuite(new TestSuite(), builder.batch(10).build());
    }

    public void testNonEnvAwareWithSplittable() {
        TestSuiteBuilder builder = new TestSuiteBuilder().maxBatch(2);
        builder.addTest(TestFiveSplit.class);
        builder.addTest(TestNonEnvAware.class);
        TestSuite expected = new TestSuite();
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test1", "test2", "test3"));
        this.assertTestSuite(expected, builder.batch(1).build());
        expected = new TestSuite();
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test4", "test5"));
        expected.addTestSuite(TestNonEnvAware.class);
        this.assertTestSuite(expected, builder.batch(2).build());
    }

    public void testNonEnvAwareWithoutSplit() {
        TestSuiteBuilder builder = new TestSuiteBuilder().maxBatch(2);
        builder.addTest(TestTwo.class);
        builder.addTest(TestNonEnvAware.class);
        TestSuite expected = new TestSuite();
        expected.addTestSuite(TestTwo.class);
        this.assertTestSuite(expected, builder.batch(1).build());
        expected = new TestSuite();
        expected.addTestSuite(TestNonEnvAware.class);
        this.assertTestSuite(expected, builder.batch(2).build());
    }

    public void testSplitAndNonSplit() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 5);
        builder.addTests(TestFive.class, TestOne.class, TestFiveSplit.class, TestFour.class, TestTwo.class, TestThree.class, TestNonEnvAware.class);
        TestSuite expected = new TestSuite();
        expected.addTestSuite(TestFive.class);
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test1"));
        this.assertTestSuite(expected, builder.build());
        expected = new TestSuite();
        expected.addTestSuite(TestOne.class);
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test2"));
        expected.addTestSuite(TestFour.class);
        this.assertTestSuite(expected, builder.batch(2).build());
        expected = new TestSuite();
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test3"));
        expected.addTestSuite(TestTwo.class);
        this.assertTestSuite(expected, builder.batch(3).build());
        expected = new TestSuite();
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test4"));
        expected.addTestSuite(TestThree.class);
        this.assertTestSuite(expected, builder.batch(4).build());
        expected = new TestSuite();
        expected.addTest((Test)this.splitTest(TestFiveSplit.class, "test5"));
        expected.addTestSuite(TestNonEnvAware.class);
        this.assertTestSuite(expected, builder.batch(5).build());
    }

    public void testEnvironmentAware() throws Exception {
        JIRAEnvironmentData envData = (JIRAEnvironmentData)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{JIRAEnvironmentData.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) {
                throw new UnsupportedOperationException();
            }
        });
        TestSuiteBuilder builder = new TestSuiteBuilder();
        Test test = builder.addTest(TestEnvAware.class).addTest(TestFive.class).build();
        TestTestSuiteBuilder.assertTrue((boolean)(test instanceof EnvironmentAware));
        ((EnvironmentAware)test).setEnvironmentData(envData);
        TestTestSuiteBuilder.assertEquals((int)1, (int)TestEnvAware.callCount);
        TestTestSuiteBuilder.assertSame((Object)envData, (Object)TestEnvAware.envData);
    }

    public void testBadState() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 5);
        builder.maxBatch(-1).batch(5);
        builder.addTest(TestOne.class);
        try {
            builder.build();
            TestTestSuiteBuilder.fail((String)"Should be in illegal state.");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        builder.maxBatch(4);
        try {
            builder.build();
            TestTestSuiteBuilder.fail((String)"Should be in an illegal state.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBadBatch() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 5);
        try {
            builder.batch(0);
            TestTestSuiteBuilder.fail((String)"Should now allow zero to be set for batch number.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBadMaxBatch() throws Exception {
        TestSuiteBuilder builder = new TestSuiteBuilder(1, 5);
        try {
            builder.maxBatch(0);
            TestTestSuiteBuilder.fail((String)"Should now allow zero to be set for max batch number.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAcceptanceTestHarness() throws Exception {
        Set<Class<? extends TestCase>> classes = AcceptanceTestHarness.SUITE.getFuncTests();
        TestSuiteBuilder splitter = new TestSuiteBuilder().maxBatch(15).addTests(classes);
        int total = 0;
        for (int i = 1; i <= 15; ++i) {
            TestSuite t = (TestSuite)splitter.batch(i).build();
            total += t.countTestCases();
            System.out.printf("Batch %d: %d.%n", i, t.countTestCases());
        }
        System.out.printf("Total: %d.%n", total);
        TestSuite test = (TestSuite)splitter.batch(-1).build();
        TestTestSuiteBuilder.assertEquals((int)test.countTestCases(), (int)total);
        System.out.println("Total: " + test.countTestCases() + ".");
    }

    private TestSuite wrapInSuite(Test test) {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(test);
        return testSuite;
    }

    private TestSuite splitTest(Class<? extends TestCase> test, String ... names) {
        TestSuite suite = new TestSuite(test);
        HashMap<String, TestCase> nameMap = new HashMap<String, TestCase>();
        Enumeration enumeration = suite.tests();
        while (enumeration.hasMoreElements()) {
            TestCase innerCase;
            Test innerTest = (Test)enumeration.nextElement();
            if (!(innerTest instanceof TestCase) || nameMap.put((innerCase = (TestCase)innerTest).getName(), innerCase) == null) continue;
            TestTestSuiteBuilder.fail((String)"Test contained two tests of the same name.");
        }
        TestSuite returnSuite = new TestSuite(suite.getName());
        for (String name : names) {
            Test innerTest = (Test)nameMap.get(name);
            TestTestSuiteBuilder.assertNotNull((String)String.format("Could not find test for '%s' on class '%s'.", name, test.getName()), (Object)innerTest);
            returnSuite.addTest(innerTest);
        }
        return returnSuite;
    }

    private static TestSuite createTestSuite(Class<? extends TestCase> ... args) {
        TestSuite expected = new TestSuite();
        for (Class<? extends TestCase> arg : args) {
            expected.addTestSuite(arg);
        }
        return expected;
    }

    private void assertTestSuite(Test actual, Class<? extends TestCase> ... args) {
        if (!(actual instanceof TestSuite)) {
            TestTestSuiteBuilder.fail((String)String.format("Expected test to be a '%s' but was a '%s'.", TestSuite.class.getName(), actual.getClass().getName()));
        }
        this.assertSuiteEquals(TestTestSuiteBuilder.createTestSuite(args), (TestSuite)actual);
    }

    private void assertTestSuite(TestSuite expected, Test actual) {
        if (!(actual instanceof TestSuite)) {
            TestTestSuiteBuilder.fail((String)String.format("Expected test to be a '%s' but was a '%s'.", TestSuite.class.getName(), actual.getClass().getName()));
        }
        this.assertSuiteEquals(expected, (TestSuite)actual);
    }

    private void assertSuiteEquals(TestSuite expected, TestSuite actual) {
        TestTestSuiteBuilder.assertEquals((String)"Tests did not have same number of test cases.", (int)expected.countTestCases(), (int)actual.countTestCases());
        Enumeration expectedEnum = expected.tests();
        while (expectedEnum.hasMoreElements()) {
            Test expectedTest = (Test)expectedEnum.nextElement();
            if (expectedTest instanceof TestSuite) {
                TestSuite expectedSuite = (TestSuite)expectedTest;
                TestSuite actualSuite = this.findSuite(expectedSuite, actual);
                if (actualSuite == null) {
                    TestTestSuiteBuilder.fail((String)("Actual suite did not contain TestSuite: " + expectedSuite.getName()));
                }
                this.assertSuiteEquals(expectedSuite, actualSuite);
                continue;
            }
            if (expectedTest instanceof TestCase) {
                TestCase expectedCase = (TestCase)expectedTest;
                if (this.findTestCaseInSuite(expectedCase, actual)) continue;
                TestTestSuiteBuilder.fail((String)("Actual suite did not contain TestCase: " + expectedCase.getName()));
                continue;
            }
            if (this.findTest(expectedTest, actual)) continue;
            TestTestSuiteBuilder.fail((String)("Actual suite did not contain Test: " + expectedTest));
        }
    }

    private TestSuite findSuite(TestSuite findSuite, TestSuite suite) {
        Enumeration testEnum = suite.tests();
        while (testEnum.hasMoreElements()) {
            TestSuite testSuite;
            Test test = (Test)testEnum.nextElement();
            if (!(test instanceof TestSuite) || !(testSuite = (TestSuite)test).getName().equals(findSuite.getName())) continue;
            return testSuite;
        }
        return null;
    }

    private boolean findTestCaseInSuite(TestCase findTest, TestSuite suite) {
        Enumeration expectedEnum = suite.tests();
        while (expectedEnum.hasMoreElements()) {
            Test actualTest = (Test)expectedEnum.nextElement();
            if (actualTest.getClass() != findTest.getClass() || !((TestCase)actualTest).getName().equals(findTest.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean findTest(Test test, TestSuite suite) {
        Enumeration expectedEnum = suite.tests();
        while (expectedEnum.hasMoreElements()) {
            Test expectedTest = (Test)expectedEnum.nextElement();
            if (!expectedTest.equals(test)) continue;
            return true;
        }
        return false;
    }

    public static class TestEnvAware
    extends TestCase
    implements EnvironmentAware {
        private static int callCount = 0;
        private static JIRAEnvironmentData envData = null;

        public void testStuff() throws Exception {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
            ++callCount;
            envData = environmentData;
        }
    }

    public static class TestNonEnvAware
    extends TestCase {
        public void test1() {
        }

        public void test2() {
        }

        public void test3() {
        }

        public void test4() {
        }

        public void test5() {
        }

        public void test6() {
        }

        public void test7() {
        }
    }

    @Splitable
    public static class TestFiveSplit
    extends TestCase
    implements EnvironmentAware {
        public void test5() {
        }

        public void test1() {
        }

        public void test2() {
        }

        public void test3() {
        }

        public void test4() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }

    public static class TestFive
    extends TestCase
    implements EnvironmentAware {
        public void testFiveOne() {
        }

        public void testFiveTwo() {
        }

        public void testFiveThree() {
        }

        public void testFiveFour() {
        }

        public void testFiveFive() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }

    public static class TestFour
    extends TestCase
    implements EnvironmentAware {
        public void testFourOne() {
        }

        public void testFourTwo() {
        }

        public void testFourThree() {
        }

        public void testFourFour() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }

    public static class TestThree
    extends TestCase
    implements EnvironmentAware {
        public void testThreeOne() {
        }

        public void testThreeTwo() {
        }

        public void testThreeThree() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }

    public static class TestTwo
    extends TestCase
    implements EnvironmentAware {
        public void testTwoOne() {
        }

        public void testTwoTwo() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }

    public static class TestOne
    extends TestCase
    implements EnvironmentAware {
        public void testOneOne() {
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        }
    }
}

