/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests;

import com.atlassian.jira.webtests.util.TestClassUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingTestFinder {
    public void findTestsMissingFromTestHarness(String packageForAllTests, String harnessSuiteName, Set<Class<? extends TestCase>> testsDefinedInSuite, Set<Class<? extends TestCase>> ignoredTests) {
        this.findTestsMissingFromTestHarness(TestClassUtils.getTestClasses(packageForAllTests), harnessSuiteName, testsDefinedInSuite, ignoredTests);
    }

    public void findTestsMissingFromTestHarness(Collection<Class<? extends TestCase>> allTestCases, String harnessSuiteName, Set<Class<? extends TestCase>> testsDefinedInSuite, Set<Class<? extends TestCase>> ignoredTests) {
        HashSet<Class<? extends TestCase>> allIncludedTests = new HashSet<Class<? extends TestCase>>();
        allIncludedTests.addAll(testsDefinedInSuite);
        StringBuilder missingTests = new StringBuilder();
        int missingTestCount = 0;
        for (Class<? extends TestCase> testClass : allTestCases) {
            if (allIncludedTests.contains(testClass) || ignoredTests.contains(testClass) || !testClass.getSimpleName().startsWith("Test")) continue;
            missingTests.append("\n  ").append(testClass.getName());
            ++missingTestCount;
        }
        if (missingTestCount > 0) {
            Assert.fail((String)("Found " + missingTestCount + " Tests that are unknown to " + harnessSuiteName + ":" + missingTests.toString() + "\n"));
        }
    }
}

