/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.form;

import com.atlassian.jira.functest.framework.util.dom.DomNodeCopier;
import com.atlassian.jira.util.dbc.Assertions;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebRequest;
import java.io.IOException;
import java.util.Map;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.TestContext;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormParameterUtil {
    private final String formIdentifierOrName;
    private final TestContext context;
    private final HttpUnitDialog dialog;
    private final WebRequest request;
    boolean isNotSubmitted = true;

    public FormParameterUtil(WebTester tester, String formIdentifierOrName, String submitButtonName) {
        HttpUnitOptions.setParameterValuesValidated((boolean)false);
        this.formIdentifierOrName = formIdentifierOrName;
        this.context = tester.getTestContext();
        this.dialog = tester.getDialog();
        this.dialog.setWorkingForm(formIdentifierOrName);
        this.request = StringUtils.isNotBlank((String)submitButtonName) ? this.dialog.getForm().getRequest(submitButtonName) : this.dialog.getForm().getRequest();
    }

    public void addOptionToHtmlSelect(String select, String[] value) {
        if (value != null) {
            String[] vals = this.dialog.getOptionValuesFor(select);
            String[] modifiedVals = new String[vals.length + value.length];
            System.arraycopy(vals, 0, modifiedVals, 0, vals.length);
            System.arraycopy(value, 0, modifiedVals, vals.length, value.length);
            this.request.setParameter(select, modifiedVals);
        }
    }

    public void replaceOptionsinHtmlSelect(String select, String[] value) {
        if (value != null) {
            this.request.setParameter(select, value);
        }
    }

    public void setFormElement(String formElementName, String value) {
        if (value != null) {
            this.request.setParameter(formElementName, value);
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        for (String param : parameters.keySet()) {
            this.request.setParameter(param, parameters.get(param));
        }
    }

    public Node submitForm() {
        Assertions.stateTrue("form has not been submitted", this.isNotSubmitted);
        try {
            DomNodeCopier copier = new DomNodeCopier(this.dialog.getWebClient().sendRequest(this.request).getDOM(), true);
            if (copier != null) {
                Node node = copier.getCopiedNode();
                return node;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.isNotSubmitted = false;
            HttpUnitOptions.setParameterValuesValidated((boolean)true);
        }
        return null;
    }
}

