/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.MultiSelectCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;

public class PriorityCondition
extends MultiSelectCondition {
    public PriorityCondition() {
        super("priority");
    }

    public PriorityCondition(PriorityCondition priorityCondition) {
        super(priorityCondition);
    }

    public NavigatorCondition copyCondition() {
        return new PriorityCondition(this);
    }

    public NavigatorCondition copyConditionForParse() {
        return new PriorityCondition();
    }

    public PriorityCondition addPriority(Type priority) {
        this.addOption(priority.getName());
        return this;
    }

    public String toString() {
        return "Priority [" + this.getOptions() + "]";
    }

    public static class Type {
        public static final Type BLOCKER = new Type("Blocker");
        public static final Type CRITICAL = new Type("Critical");
        public static final Type MAJOR = new Type("Major");
        public static final Type MINOR = new Type("Minor");
        public static final Type TRIVIAL = new Type("Trivial");
        private final String name;

        public Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type = (Type)o;
            return this.name.equals(type.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

