/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import junit.framework.Assert;
import net.sourceforge.jwebunit.HttpUnitDialog;
import net.sourceforge.jwebunit.WebTester;

public class GenericQueryCondition
implements NavigatorCondition {
    private final String elementName;
    private String query;

    public GenericQueryCondition(String elementName) {
        this.elementName = elementName;
    }

    public void setForm(WebTester tester) {
        HttpUnitDialog dialog = tester.getDialog();
        WebForm form = dialog.getForm();
        form.setParameter(this.elementName, this.query);
    }

    public GenericQueryCondition setQuery(String q) {
        this.query = q;
        return this;
    }

    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.query = form.getParameterValue(this.elementName);
    }

    public void assertSettings(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        Assert.assertEquals((String)("Value not set correctly for element: " + this.elementName), (String)this.query, (String)form.getParameterValue(this.elementName));
    }

    public String toString() {
        return String.format("[%s: %s]", this.elementName, this.query);
    }

    public NavigatorCondition copyCondition() {
        throw new UnsupportedOperationException();
    }

    public NavigatorCondition copyConditionForParse() {
        throw new UnsupportedOperationException();
    }
}

