/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsCondition
implements SearchResultsCondition {
    private final Collection<String> columns;

    public ColumnsCondition(Collection<String> columns) {
        this.columns = new ArrayList<String>(columns);
    }

    public ColumnsCondition(String[] columns) {
        this(Arrays.asList(columns));
    }

    @Override
    public void assertCondition(WebTester tester) {
        WebTable table = null;
        try {
            table = tester.getDialog().getResponse().getTableWithID("issuetable");
        }
        catch (SAXException e) {
            Assert.fail((String)("Expected columns '" + this.columns + "' to be visible: Unable to find issue table -" + e.getMessage()));
        }
        if (table == null) {
            if (!this.columns.isEmpty()) {
                Assert.fail((String)("Expected columns '" + this.columns + "' to be visible: Issue table not visible."));
            }
        } else {
            int columnMax = table.getColumnCount();
            int columnPos = 0;
            for (String column : this.columns) {
                String content;
                if (columnPos >= columnMax) {
                    Assert.fail((String)("Expected columns '" + this.columns + "' to be visible. Unable to find column '" + column + "."));
                }
                if (!column.equals(content = StringUtils.trimToNull((String)table.getCellAsText(0, columnPos)))) {
                    Assert.fail((String)("Expected columns '" + this.columns + "' to be visible: Found column '" + content + "' instead of '" + column + "'."));
                }
                ++columnPos;
            }
            if (columnPos < columnMax) {
                Assert.fail((String)("Exepcted columns '" + this.columns + "' to be visible: Found extra column '" + StringUtils.trimToNull((String)table.getCellAsText(0, columnPos)) + "'."));
            }
        }
    }
}

