/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FileAttachmentsList {
    public List<FileAttachmentItem> get();

    public static class ZipFileAttachmentEntry {
        private String name;
        private String size;

        private ZipFileAttachmentEntry(String name, String size) {
            this.name = name;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return this.size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ZipFileAttachmentEntry)) {
                return false;
            }
            ZipFileAttachmentEntry rhs = (ZipFileAttachmentEntry)obj;
            return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getSize(), (Object)rhs.getSize()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.size).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("size", (Object)this.size).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileAttachmentItem {
        private String name;
        private String size;
        private String author;
        private String date;
        private List<ZipFileAttachmentEntry> zipEntries;

        FileAttachmentItem(String name, String size, String author, String date, List<ZipFileAttachmentEntry> zipEntries) {
            this.name = name;
            this.size = size;
            this.author = author;
            this.date = date;
            this.zipEntries = zipEntries;
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return this.size;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getDate() {
            return this.date;
        }

        public List<ZipFileAttachmentEntry> getZipEntries() {
            return Collections.unmodifiableList(this.zipEntries);
        }

        public boolean isZip() {
            return !this.zipEntries.isEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FileAttachmentItem)) {
                return false;
            }
            FileAttachmentItem rhs = (FileAttachmentItem)obj;
            return new EqualsBuilder().append((Object)this.date, (Object)rhs.date).append((Object)this.name, (Object)rhs.name).append((Object)this.size, (Object)rhs.size).append((Object)this.author, (Object)rhs.author).append(this.zipEntries, rhs.zipEntries).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.date).append((Object)this.name).append((Object)this.size).append((Object)this.author).append(this.zipEntries).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("size", (Object)this.size).append("author", (Object)this.author).append("date", (Object)this.date).append("zipEntries", this.zipEntries).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Items {
        public static ZipFileAttachmentEntry zipEntry(String name, String size) {
            return new ZipFileAttachmentEntry(name, size);
        }

        public static FileAttachmentItem zip(String name, String size, String author, String date, List<ZipFileAttachmentEntry> zipFileEntries) {
            return new FileAttachmentItem(name, size, author, date, zipFileEntries);
        }

        public static FileAttachmentItem file(String name, String size, String author, String date) {
            return new FileAttachmentItem(name, size, author, date, Collections.<ZipFileAttachmentEntry>emptyList());
        }
    }
}

